/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public final class KubernetesUtils {
    private static final Logger LOG = Logger.getLogger(KubernetesUtils.class.getName());

    private KubernetesUtils() {
    }

    public static int indexFromName(String name) {
        return Integer.parseInt(name.substring(name.lastIndexOf("-") + 1));
    }

    public static String removeIndexFromName(String name) {
        return name.substring(0, name.lastIndexOf("-"));
    }

    public static String[] createCopyCommand(String filename, String namespace, String podName, String podFile) {
        String targetDir = String.format("%s/%s:%s", namespace, podName, podFile);
        return new String[]{"kubectl", "cp", filename, targetDir};
    }

    public static String podNameFromStatefulSetName(String ssName, int podIndex) {
        return ssName + "-" + podIndex;
    }

    public static String createServiceName(String jobID) {
        return jobID;
    }

    public static String createJobMasterServiceName(String jobID) {
        return jobID + "-jm";
    }

    public static String createPersistentVolumeName(String jobID) {
        return "persistent-volume-" + jobID;
    }

    public static HashMap<String, String> createJobLabels(String jobID) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("app", "twister2");
        labels.put("t2-job", jobID);
        return labels;
    }

    public static String twister2LabelSelector() {
        return "app=twister2";
    }

    public static String jobLabelSelector(String jobID) {
        return "t2-job=" + jobID;
    }

    public static String jobMasterPodLabelSelector(String jobID) {
        return "t2-mp=" + jobID;
    }

    public static String workerPodLabelSelector(String jobID) {
        return "t2-wp=" + jobID;
    }

    public static String createContainerName(int containerIndex) {
        return "twister2-container-" + containerIndex;
    }

    public static String createWorkersStatefulSetName(String jobID, int index) {
        return jobID + "-" + index;
    }

    public static String createJobMasterStatefulSetName(String jobID) {
        return jobID + "-jm";
    }

    public static String createJobMasterPodName(String jobID) {
        return KubernetesUtils.createJobMasterStatefulSetName(jobID) + "-0";
    }

    public static String createRestartWorkerKey(int workerID) {
        return "RESTART_COUNT_FOR_WORKER_" + workerID;
    }

    public static String createRestartJobMasterKey() {
        return "RESTART_COUNT_FOR_JOB_MASTER";
    }

    public static String jobPackageFullPath(Config config, String jobID) {
        String uploaderDir = KubernetesContext.uploaderWebServerDirectory(config);
        String jobPackageFullPath = uploaderDir + "/" + JobUtils.createJobPackageFileName(jobID);
        return jobPackageFullPath;
    }

    public static int numberOfWorkerPods(JobAPI.Job job) {
        int podsCount = 0;
        for (JobAPI.ComputeResource computeResource : job.getComputeResourceList()) {
            podsCount += computeResource.getInstances();
        }
        return podsCount;
    }

    public static ArrayList<String> generatePodNames(JobAPI.Job job) {
        ArrayList<String> podNames = new ArrayList<String>();
        List resourceList = job.getComputeResourceList();
        for (int i = 0; i < resourceList.size(); ++i) {
            JobAPI.ComputeResource computeResource = (JobAPI.ComputeResource)resourceList.get(i);
            int podsCount = computeResource.getInstances();
            int index = computeResource.getIndex();
            for (int j = 0; j < podsCount; ++j) {
                String ssName = KubernetesUtils.createWorkersStatefulSetName(job.getJobId(), index);
                String podName = KubernetesUtils.podNameFromStatefulSetName(ssName, j);
                podNames.add(podName);
            }
        }
        return podNames;
    }

    public static boolean isPodRunning(V1Pod pod) {
        return "Running".equals(pod.getStatus().getPhase()) && pod.getMetadata().getDeletionTimestamp() == null && KubernetesUtils.allContainersReady(pod.getStatus().getContainerStatuses());
    }

    public static boolean allContainersReady(List<V1ContainerStatus> contStatuses) {
        for (V1ContainerStatus cs : contStatuses) {
            if (cs.getReady().booleanValue()) continue;
            return false;
        }
        return true;
    }
}

