/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import java.util.List;

public class KubernetesContext
extends SchedulerContext {
    public static final String TWISTER2_DOCKER_IMAGE_FOR_K8S = "twister2.resource.kubernetes.docker.image";
    public static final String KUBERNETES_NAMESPACE_DEFAULT = "default";
    public static final String KUBERNETES_NAMESPACE = "kubernetes.namespace";
    public static final boolean K8S_LOG_IN_CLIENT_DEFAULT = false;
    public static final String K8S_LOG_IN_CLIENT = "kubernetes.log.in.client";
    public static final int K8S_WORKER_BASE_PORT_DEFAULT = 9000;
    public static final String K8S_WORKER_BASE_PORT = "kubernetes.worker.base.port";
    public static final boolean NODE_LOCATIONS_FROM_CONFIG_DEFAULT = true;
    public static final String NODE_LOCATIONS_FROM_CONFIG = "twister2.resource.kubernetes.node.locations.from.config";
    public static final boolean NODE_PORT_SERVICE_REQUESTED_DEFAULT = false;
    public static final String NODE_PORT_SERVICE_REQUESTED = "kubernetes.node.port.service.requested";
    public static final int SERVICE_NODE_PORT_DEFAULT = 0;
    public static final String SERVICE_NODE_PORT = "kubernetes.service.node.port";
    public static final String WORKER_TRANSPORT_PROTOCOL_DEFAULT = "TCP";
    public static final String WORKER_TRANSPORT_PROTOCOL = "kubernetes.worker.transport.protocol";
    public static final String K8S_IMAGE_PULL_POLICY_NAMESPACE = "IfNotPresent";
    public static final String K8S_IMAGE_PULL_POLICY = "kubernetes.image.pull.policy";
    public static final String K8S_PERSISTENT_STORAGE_CLASS = "twister2.resource.kubernetes.persistent.storage.class";
    public static final String K8S_STORAGE_ACCESS_MODE_DEFAULT = "ReadWriteMany";
    public static final String K8S_STORAGE_ACCESS_MODE = "twister2.resource.kubernetes.storage.access.mode";
    public static final boolean K8S_BIND_WORKER_TO_CPU_DEFAULT = false;
    public static final String K8S_BIND_WORKER_TO_CPU = "kubernetes.bind.worker.to.cpu";
    public static final boolean K8S_WORKER_TO_NODE_MAPPING_DEFAULT = false;
    public static final String K8S_WORKER_TO_NODE_MAPPING = "kubernetes.worker.to.node.mapping";
    public static final String K8S_WORKER_MAPPING_KEY = "twister2.resource.kubernetes.worker.mapping.key";
    public static final String K8S_WORKER_MAPPING_OPERATOR = "twister2.resource.kubernetes.worker.mapping.operator";
    public static final String K8S_WORKER_MAPPING_VALUES = "twister2.resource.kubernetes.worker.mapping.values";
    public static final String K8S_WORKER_MAPPING_UNIFORM_DEFAULT = "none";
    public static final String K8S_WORKER_MAPPING_UNIFORM = "kubernetes.worker.mapping.uniform";
    public static final String SECRET_NAME = "kubernetes.secret.name";
    public static final String K8S_UPLOADER_WEB_SERVER_DEFAULT = "http://twister2-uploader.default.svc.cluster.local";
    public static final String K8S_UPLOADER_WEB_SERVER = "twister2.kubernetes.uploader.web.server";
    public static final String K8S_UPLOADER_WEB_SERVER_DIRECTORY_DEFAULT = "/usr/share/nginx/html";
    public static final String K8S_UPLOADER_WEB_SERVER_DIRECTORY = "twister2.kubernetes.uploader.web.server.directory";
    public static final String K8S_UPLOADER_WEB_SERVER_LABEL_DEFAULT = "app=twister2-uploader";
    public static final String K8S_UPLOADER_WEB_SERVER_LABEL = "twister2.kubernetes.uploader.web.server.label";
    public static final boolean K8S_CHECK_PWD_FREE_SSH_DEFAULT = false;
    public static final String K8S_CHECK_PWD_FREE_SSH = "twister2.kubernetes.check.pwd.free.ssh";
    public static final double K8S_JVM_MEMORY_FRACTION_DEFAULT = 0.8;
    public static final String K8S_JVM_MEMORY_FRACTION = "twister2.kubernetes.jvm.memory.fraction";

    public static String twister2DockerImageForK8s(Config cfg) {
        return cfg.getStringValue(TWISTER2_DOCKER_IMAGE_FOR_K8S);
    }

    public static String namespace(Config cfg) {
        return cfg.getStringValue(KUBERNETES_NAMESPACE, KUBERNETES_NAMESPACE_DEFAULT);
    }

    public static boolean logInClient(Config cfg) {
        return cfg.getBooleanValue(K8S_LOG_IN_CLIENT, false);
    }

    public static boolean nodeLocationsFromConfig(Config cfg) {
        return cfg.getBooleanValue(NODE_LOCATIONS_FROM_CONFIG, true);
    }

    public static String rackLabelKeyForK8s(Config cfg) {
        return cfg.getStringValue("twister2.resource.rack.labey.key");
    }

    public static String datacenterLabelKeyForK8s(Config cfg) {
        return cfg.getStringValue("twister2.resource.datacenter.labey.key");
    }

    public static boolean nodePortServiceRequested(Config cfg) {
        return cfg.getBooleanValue(NODE_PORT_SERVICE_REQUESTED, false);
    }

    public static int serviceNodePort(Config cfg) {
        return cfg.getIntegerValue(SERVICE_NODE_PORT, 0);
    }

    public static int workerBasePort(Config cfg) {
        return cfg.getIntegerValue(K8S_WORKER_BASE_PORT, 9000);
    }

    public static String imagePullPolicy(Config cfg) {
        return cfg.getStringValue(K8S_IMAGE_PULL_POLICY, K8S_IMAGE_PULL_POLICY_NAMESPACE);
    }

    public static String persistentStorageClass(Config cfg) {
        return cfg.getStringValue(K8S_PERSISTENT_STORAGE_CLASS);
    }

    public static String storageAccessMode(Config cfg) {
        return cfg.getStringValue(K8S_STORAGE_ACCESS_MODE, K8S_STORAGE_ACCESS_MODE_DEFAULT);
    }

    public static String workerTransportProtocol(Config cfg) {
        return cfg.getStringValue(WORKER_TRANSPORT_PROTOCOL, WORKER_TRANSPORT_PROTOCOL_DEFAULT);
    }

    public static boolean bindWorkerToCPU(Config cfg) {
        return cfg.getBooleanValue(K8S_BIND_WORKER_TO_CPU, false);
    }

    public static boolean workerToNodeMapping(Config cfg) {
        return cfg.getBooleanValue(K8S_WORKER_TO_NODE_MAPPING, false);
    }

    public static String workerMappingKey(Config cfg) {
        return cfg.getStringValue(K8S_WORKER_MAPPING_KEY);
    }

    public static String workerMappingOperator(Config cfg) {
        return cfg.getStringValue(K8S_WORKER_MAPPING_OPERATOR);
    }

    public static List<String> workerMappingValues(Config cfg) {
        return cfg.getStringList(K8S_WORKER_MAPPING_VALUES);
    }

    public static String workerMappingUniform(Config cfg) {
        return cfg.getStringValue(K8S_WORKER_MAPPING_UNIFORM, K8S_WORKER_MAPPING_UNIFORM_DEFAULT);
    }

    public static String secretName(Config cfg) {
        return cfg.getStringValue(SECRET_NAME);
    }

    public static String uploaderWebServer(Config cfg) {
        return cfg.getStringValue(K8S_UPLOADER_WEB_SERVER, K8S_UPLOADER_WEB_SERVER_DEFAULT);
    }

    public static String uploaderWebServerDirectory(Config cfg) {
        return cfg.getStringValue(K8S_UPLOADER_WEB_SERVER_DIRECTORY, K8S_UPLOADER_WEB_SERVER_DIRECTORY_DEFAULT);
    }

    public static String uploaderWebServerLabel(Config cfg) {
        return cfg.getStringValue(K8S_UPLOADER_WEB_SERVER_LABEL, K8S_UPLOADER_WEB_SERVER_LABEL_DEFAULT);
    }

    public static boolean checkPwdFreeSsh(Config cfg) {
        return cfg.getBooleanValue(K8S_CHECK_PWD_FREE_SSH, false);
    }

    public static double jvmMemoryFraction(Config cfg) {
        return cfg.getDoubleValue(K8S_JVM_MEMORY_FRACTION, 0.8);
    }
}

