/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ClientJobKillHandler {
    private static final Logger LOG = Logger.getLogger(ClientJobKillHandler.class.getName());
    private String jobID;
    private KubernetesController controller;
    private List<String> ssList;
    private List<String> serviceList;
    private V1ConfigMap cm;
    private V1PersistentVolumeClaim pvc;

    public ClientJobKillHandler(String jobID, KubernetesController controller) {
        this.jobID = jobID;
        this.controller = controller;
    }

    public void getInitialState() {
        this.ssList = this.getSSList();
        this.serviceList = this.getServiceList();
        this.cm = this.controller.getJobConfigMap(this.jobID);
        this.pvc = this.controller.getJobPersistentVolumeClaim(this.jobID);
    }

    public boolean allDeleted() {
        V1PersistentVolumeClaim currentPVC;
        V1ConfigMap currentCM;
        if (!this.ssList.isEmpty()) {
            List<String> currentSSList = this.getSSList();
            Iterator<String> ssIterator = this.ssList.iterator();
            while (ssIterator.hasNext()) {
                String ssName = ssIterator.next();
                if (currentSSList.contains(ssName)) continue;
                LOG.info("Deleted StatefulSet: " + ssName);
                ssIterator.remove();
            }
        }
        if (!this.serviceList.isEmpty()) {
            List<String> currentServiceList = this.getServiceList();
            Iterator<String> serviceIterator = this.serviceList.iterator();
            while (serviceIterator.hasNext()) {
                String serviceName = serviceIterator.next();
                if (currentServiceList.contains(serviceName)) continue;
                LOG.info("Deleted Service: " + serviceName);
                serviceIterator.remove();
            }
        }
        if (this.cm != null && (currentCM = this.controller.getJobConfigMap(this.jobID)) == null) {
            LOG.info("Deleted ConfigMap: " + this.cm.getMetadata().getName());
            this.cm = null;
        }
        if (this.pvc != null && (currentPVC = this.controller.getJobPersistentVolumeClaim(this.jobID)) == null) {
            LOG.info("Deleted V1PersistentVolumeClaim: " + this.pvc.getMetadata().getName());
            this.pvc = null;
        }
        return this.ssList.isEmpty() && this.serviceList.isEmpty() && this.cm == null && this.pvc == null;
    }

    private List<String> getSSList() {
        return this.controller.getJobStatefulSets(this.jobID).stream().map(ss -> ss.getMetadata().getName()).collect(Collectors.toList());
    }

    private List<String> getServiceList() {
        return this.controller.getJobServices(this.jobID).stream().map(ss -> ss.getMetadata().getName()).collect(Collectors.toList());
    }

    public boolean deleteUndeletedResources() {
        boolean allDeleted = true;
        for (String ssName : this.ssList) {
            if (this.controller.deleteStatefulSet(ssName)) continue;
            allDeleted = false;
        }
        for (String serviceName : this.serviceList) {
            if (this.controller.deleteService(serviceName)) continue;
            allDeleted = false;
        }
        if (this.cm != null && !this.controller.deleteConfigMap(this.cm.getMetadata().getName())) {
            allDeleted = true;
        }
        if (this.pvc != null && !this.controller.deletePersistentVolumeClaim(this.pvc.getMetadata().getName())) {
            allDeleted = true;
        }
        return allDeleted;
    }

    public String getUndeletedResources() {
        StringBuffer sb = new StringBuffer();
        this.ssList.forEach(ss -> sb.append("StatefulSet: " + ss + System.lineSeparator()));
        this.serviceList.forEach(ss -> sb.append("Service: " + ss + System.lineSeparator()));
        if (this.cm != null) {
            sb.append("ConfigMap: " + this.cm.getMetadata().getName() + System.lineSeparator());
        }
        if (this.pvc != null) {
            sb.append("PersistentVolumeClaim: " + this.pvc.getMetadata().getName() + System.lineSeparator());
        }
        return sb.toString();
    }
}

