/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.job;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.zk.JobWithState;
import edu.iu.dsc.tws.common.zk.JobZNodeManager;
import edu.iu.dsc.tws.common.zk.WorkerWithState;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.common.zk.ZKPersStateManager;
import edu.iu.dsc.tws.common.zk.ZKUtils;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;

public final class ZKJobLister {
    private static final Logger LOG = Logger.getLogger(ZKJobLister.class.getName());
    private static Config config;

    private ZKJobLister() {
    }

    public static void main(String[] args) {
        CommandLine cmd;
        Options cmdOptions = ZKJobLister.setupOptions();
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(cmdOptions, args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("ZKJobLister", cmdOptions);
            throw new RuntimeException("Error parsing command line options: ", e);
        }
        catch (Throwable t) {
            String msg = "Un-expected error";
            LOG.log(Level.SEVERE, msg, t);
            throw new RuntimeException(msg, t);
        }
        config = ZKJobLister.loadConfigurations(cmd);
        String command = cmd.getOptionValue("command");
        String jobID = Context.jobId((Config)config);
        LOG.log(Level.FINE, "command: " + command);
        LOG.log(Level.FINE, "jobID: " + jobID);
        if (ZKContext.serverAddresses((Config)config) == null) {
            LOG.severe("ZooKeeper server address is not provided in configuration files. Please the value of: twister2.resource.zookeeper.server.addresses");
            return;
        }
        if ("jobs".equals(jobID)) {
            ZKJobLister.listJobs();
        } else {
            ZKJobLister.listJob(jobID);
        }
    }

    public static Config loadConfigurations(CommandLine cmd) {
        String twister2Home = cmd.getOptionValue("twister2_home");
        String configDir = cmd.getOptionValue("config_path");
        String jobID = cmd.getOptionValue("job_id");
        Config conf = ConfigLoader.loadConfig((String)twister2Home, (String)configDir);
        return Config.newBuilder().putAll(conf).put(Context.TWISTER2_HOME.getKey(), (Object)twister2Home).put("config_dir", (Object)configDir).put("twister2.job.id", (Object)jobID).build();
    }

    public static Options setupOptions() {
        Options options = new Options();
        Option configDirectory = Option.builder((String)"d").desc("The config directory").longOpt("config_path").hasArgs().argName("configuration directory").required().build();
        Option twister2Home = Option.builder((String)"t").desc("The class name of the container to launch").longOpt("twister2_home").hasArgs().argName("twister2 home").required().build();
        Option command = Option.builder((String)"m").desc("Command name").longOpt("command").hasArgs().argName("command").required().build();
        Option jobID = Option.builder((String)"j").desc("Job id").longOpt("job_id").hasArgs().argName("job id").required().build();
        options.addOption(twister2Home);
        options.addOption(configDirectory);
        options.addOption(command);
        options.addOption(jobID);
        return options;
    }

    public static void listJobs() {
        List jobs;
        CuratorFramework client = ZKUtils.connectToServer((String)ZKContext.serverAddresses((Config)config));
        String rootPath = ZKContext.rootNode((Config)config);
        try {
            jobs = JobZNodeManager.getJobs((CuratorFramework)client, (String)rootPath);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not get jobs from zookeeper", e);
            return;
        }
        if (jobs.size() == 0) {
            LOG.info("\nNumber of all jobs: " + jobs.size());
            return;
        }
        int maxJobIdLength = jobs.stream().mapToInt(j -> j.getJob().getJobId().length()).max().orElseThrow(() -> new RuntimeException("No valid jobID in jobs"));
        List<JobWithState> finishedJobs = jobs.stream().filter(j -> j.finished()).collect(Collectors.toList());
        List<JobWithState> activeJobs = jobs.stream().filter(j -> j.active()).collect(Collectors.toList());
        int jobIDColumn = maxJobIdLength + 3;
        String format = "%-" + jobIDColumn + "s%-12s%s\n";
        int lineWidth = jobIDColumn + 12 + "Number of workers".length();
        String separator = StringUtils.repeat((char)'=', (int)lineWidth);
        StringBuilder buffer = new StringBuilder();
        Formatter f = new Formatter(buffer);
        f.format("\n\n%s", "Number of all jobs: " + jobs.size());
        f.format("\n%s", "");
        f.format("\n%s", "List of finished jobs: " + finishedJobs.size() + "\n");
        ZKJobLister.outputJobs(finishedJobs, f, format, separator);
        f.format("\n%s", "");
        f.format("\n%s", "List of active jobs: " + activeJobs.size() + "\n");
        ZKJobLister.outputJobs(activeJobs, f, format, separator);
        LOG.info(buffer.toString());
    }

    private static void outputJobs(List<JobWithState> jobs, Formatter f, String format, String separator) {
        f.format(format, "JobID", "JobState", "Number of workers");
        f.format("%s\n", separator);
        for (JobWithState jws : jobs) {
            f.format(format, jws.getJob().getJobId(), jws.getState().toString(), "" + jws.getJob().getNumberOfWorkers());
        }
    }

    public static void listJob(String jobID) {
        LinkedList workers;
        JobWithState job;
        CuratorFramework client = ZKUtils.connectToServer((String)ZKContext.serverAddresses((Config)config));
        String rootPath = ZKContext.rootNode((Config)config);
        try {
            job = JobZNodeManager.readJobZNode((CuratorFramework)client, (String)rootPath, (String)jobID);
            workers = ZKPersStateManager.getWorkers((CuratorFramework)client, (String)rootPath, (String)jobID);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not get the job from zookeeper: " + jobID, e);
            return;
        }
        if (workers.size() == 0) {
            LOG.info("\nNumber of workers in the job: 0");
            return;
        }
        int maxWorkerIPLength = workers.stream().mapToInt(w -> w.getInfo().getWorkerIP().length()).max().orElseThrow(() -> new RuntimeException("No valid workerIP in WorkerInfo"));
        StringBuilder buffer = new StringBuilder();
        Formatter f = new Formatter(buffer);
        f.format("\n\n%s", "JobID: " + job.getJob().getJobId());
        f.format("\n%s", "Job State: " + job.getState());
        f.format("\n%s", "Number of Workers: " + job.getJob().getNumberOfWorkers());
        f.format("\n%s", "");
        f.format("\n%s", "List of Workers: \n");
        int workerIDColumn = "WorkerID".length() + 3;
        int workerIPColumn = maxWorkerIPLength + 3;
        String format = "%-" + workerIDColumn + "s%-" + workerIPColumn + "s%s\n";
        int lineWidth = workerIDColumn + workerIPColumn + "Worker State".length();
        String separator = StringUtils.repeat((char)'=', (int)lineWidth);
        f.format(format, "WorkerID", "WorkerIP", "Worker State");
        f.format("%s\n", separator);
        for (WorkerWithState wws : workers) {
            f.format(format, "" + wws.getWorkerID(), wws.getInfo().getWorkerIP(), wws.getState().toString());
        }
        LOG.info(buffer.toString());
    }
}

