/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.job;

import edu.iu.dsc.tws.api.Twister2Job;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.scheduler.Twister2JobState;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.core.ResourceAllocator;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.uploaders.localfs.FsContext;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import edu.iu.dsc.tws.rsched.utils.TarGzipPacker;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class Twister2Submitter {
    private static final Logger LOG = Logger.getLogger(Twister2Submitter.class.getName());

    private Twister2Submitter() {
    }

    public static void submitJob(Twister2Job twister2Job) {
        Twister2Submitter.submitJob(twister2Job, ResourceAllocator.loadConfig((Map<String, Object>)twister2Job.getConfig()));
    }

    public static Twister2JobState submitJob(Twister2Job twister2Job, Config config) {
        String userName;
        if (Context.jobId((Config)config) != null) {
            twister2Job.setJobID(Context.jobId((Config)config));
        }
        if ((userName = Context.userName((Config)config)) == null) {
            userName = System.getProperty("user.name");
        }
        twister2Job.setUserName(userName);
        JobAPI.Job job = twister2Job.serialize();
        Config updatedConfig = JobUtils.updateConfigs(job, config);
        Twister2Submitter.writeJobIdToFile(job.getJobId());
        Twister2Submitter.printJobInfo(job, updatedConfig);
        ResourceAllocator resourceAllocator = new ResourceAllocator(updatedConfig, job);
        return resourceAllocator.submitJob();
    }

    public static Twister2JobState restartJob(String jobID, Config config) {
        Path tempDirPath;
        String prevJobDir = FsContext.uploaderJobDirectory(config) + File.separator + jobID;
        String jobPackage = prevJobDir + File.separator + SchedulerContext.jobPackageFileName((Config)config);
        Path jobPackageFile = Paths.get(jobPackage, new String[0]);
        if (Files.notExists(jobPackageFile, new LinkOption[0])) {
            LOG.severe("Job Package File does not exist: " + jobPackage);
            return new Twister2JobState(false);
        }
        try {
            tempDirPath = Files.createTempDirectory(jobID, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Twister2RuntimeException("Can not create temp directory", (Throwable)e);
        }
        TarGzipPacker.unpack(jobPackageFile, tempDirPath);
        String unpackedJobDir = tempDirPath + File.separator + "twister2-job";
        String jobFile = unpackedJobDir + File.separator + SchedulerContext.createJobDescriptionFileName((String)jobID);
        JobAPI.Job job = JobUtils.readJobFile(jobFile);
        Config prevConfig = ConfigLoader.loadConfig((String)Context.twister2Home((Config)config), (String)unpackedJobDir, (String)Context.clusterType((Config)config));
        try {
            Files.delete(tempDirPath);
            LOG.info("Unpacked job directory deleted: " + tempDirPath);
        }
        catch (IOException e) {
            LOG.warning("Exception when deleting temp directory: " + tempDirPath);
        }
        URI packageURI = null;
        try {
            packageURI = new URI(prevJobDir);
        }
        catch (URISyntaxException e) {
            throw new Twister2RuntimeException("Can not ceate URI for directory: " + prevJobDir, (Throwable)e);
        }
        prevConfig = Config.newBuilder().putAll(prevConfig).put("twister2.checkpointing.restore.job", (Object)true).put("temporary.packages.path", (Object)prevJobDir).put("job_file", (Object)job.getJobFormat().getJobFile()).put("twister2.job.package.uri", (Object)packageURI).put(Context.TWISTER2_HOME.getKey(), (Object)Context.twister2Home((Config)config)).put("twister2.job.id", (Object)jobID).put("twister2.cluster.type", (Object)Context.clusterType((Config)config)).build();
        Twister2Submitter.writeJobIdToFile(jobID);
        Twister2Submitter.printJobInfo(job, prevConfig);
        ResourceAllocator resourceAllocator = new ResourceAllocator(prevConfig, job);
        return resourceAllocator.resubmitJob();
    }

    private static void writeJobIdToFile(String jobID) {
        String dir = System.getProperty("user.home") + File.separator + ".twister2";
        if (!FileUtils.isDirectoryExists(dir)) {
            FileUtils.createDirectory(dir);
        }
        String filename = dir + File.separator + "last-job-id.txt";
        FileUtils.writeToFile(filename, (jobID + "").getBytes(), true);
    }

    private static void printJobInfo(JobAPI.Job job, Config config) {
        LOG.info("\n\n _____           _     _           ____  \n/__   \\__      _(_)___| |_ ___ _ _|___ \\ \n  / /\\/\\ \\ /\\ / / / __| __/ _ \\ '__|__) |\n / /    \\ V  V /| \\__ \\ ||  __/ |  / __/ \n \\/      \\_/\\_/ |_|___/\\__\\___|_| |_____| v0.7.0\n                                         \nJob ID      \t  :\t" + job.getJobId() + "\nNumber of Workers :\t" + job.getNumberOfWorkers() + "\nWorker Class\t  :\t" + job.getWorkerClassName() + "\n" + JobUtils.computeResourcesToPrint(job) + "\nCluster Type\t  :\t" + Context.clusterType((Config)config) + "\nRuntime     \t  :\t" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "\n\n");
    }

    public static void terminateJob(String jobID, Config config) {
        ResourceAllocator.killJob(jobID, config);
    }

    public static void clearJob(String jobID, Config config) {
        Twister2Submitter.deleteJobDir(jobID, config);
        if (KubernetesContext.isKubernetesCluster((Config)config)) {
            KubernetesController controller = KubernetesController.init(KubernetesContext.namespace(config));
            controller.deletePersistentVolumeClaim(jobID);
            KubernetesController.close();
        }
    }

    private static void deleteJobDir(String jobID, Config config) {
        String jobDir = FsContext.uploaderJobDirectory(config) + File.separator + jobID;
        Path jobPackageFile = Paths.get(jobDir, new String[0]);
        if (Files.notExists(jobPackageFile, new LinkOption[0])) {
            LOG.severe("Job Package directory does not exist: " + jobDir);
        } else {
            LOG.info("Cleaning job directory: " + jobDir);
            FileUtils.deleteDir(jobDir);
        }
    }

    public static void clearAllJobs(Config config) {
        List<Object> runningJobs = new LinkedList();
        KubernetesController controller = null;
        if (KubernetesContext.isKubernetesCluster((Config)config)) {
            controller = KubernetesController.init(KubernetesContext.namespace(config));
            runningJobs = controller.getTwister2ConfigMapNames();
        }
        List<String> localJobDirs = FileUtils.getDirectories(FsContext.uploaderJobDirectory(config));
        localJobDirs.removeIf(runningJobs::contains);
        localJobDirs.forEach(jd -> Twister2Submitter.deleteJobDir(jd, config));
        if (KubernetesContext.isKubernetesCluster((Config)config)) {
            List<String> pvcList = controller.getTwister2PersistentVolumeClaims();
            pvcList.removeIf(runningJobs::contains);
            pvcList.forEach(controller::deletePersistentVolumeClaim);
            controller.close();
        }
    }
}

