/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.core;

import edu.iu.dsc.tws.api.checkpointing.CheckpointingClient;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.resource.IAllJoinedListener;
import edu.iu.dsc.tws.api.resource.IJobMasterFailureListener;
import edu.iu.dsc.tws.api.resource.IReceiverFromDriver;
import edu.iu.dsc.tws.api.resource.IScalerListener;
import edu.iu.dsc.tws.api.resource.ISenderToDriver;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.IWorkerFailureListener;
import edu.iu.dsc.tws.api.resource.IWorkerStatusUpdater;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingContext;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.common.zk.ZKUtils;
import edu.iu.dsc.tws.common.zk.ZKWorkerController;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.worker.JMWorkerAgent;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.K8sEnvVariables;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIWorkerController;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WorkerRuntime {
    private static final Logger LOG = Logger.getLogger(WorkerRuntime.class.getName());
    private static boolean initialized = false;
    private static Config config;
    private static JobAPI.Job job;
    private static JobMasterAPI.WorkerInfo workerInfo;
    private static ZKWorkerController zkWorkerController;
    private static JMWorkerAgent jmWorkerAgent;
    private static MPIWorkerController mpiWorkerController;
    private static boolean mpiWC;
    private static IWorkerController workerController;
    private static IWorkerStatusUpdater workerStatusUpdater;
    private static ISenderToDriver senderToDriver;
    private static IWorkerFailureListener failureListener;

    private WorkerRuntime() {
    }

    public static synchronized boolean init(Config cnfg, MPIWorkerController wc) {
        if (initialized) {
            return false;
        }
        config = cnfg;
        mpiWC = true;
        mpiWorkerController = wc;
        workerController = mpiWorkerController;
        workerStatusUpdater = null;
        senderToDriver = null;
        initialized = true;
        return true;
    }

    public static synchronized boolean init(Config cnfg, JobAPI.Job jb, JobMasterAPI.WorkerInfo wInfo, int restartCount) {
        if (initialized) {
            return false;
        }
        config = cnfg;
        job = jb;
        workerInfo = wInfo;
        String jobMasterIP = JobMasterContext.jobMasterIP((Config)config);
        if (ZKContext.isZooKeeperServerUsed((Config)config)) {
            zkWorkerController = new ZKWorkerController(config, job.getJobId(), job.getNumberOfWorkers(), workerInfo);
            try {
                long jsTime = Long.parseLong(System.getenv(K8sEnvVariables.JOB_SUBMISSION_TIME.name()));
                zkWorkerController.initialize(restartCount, jsTime);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception when initializing ZKWorkerController", e);
                throw new RuntimeException(e);
            }
            workerController = zkWorkerController;
            workerStatusUpdater = zkWorkerController;
        } else {
            jmWorkerAgent = JMWorkerAgent.createJMWorkerAgent((Config)config, (JobMasterAPI.WorkerInfo)workerInfo, (String)jobMasterIP, (int)JobMasterContext.jobMasterPort((Config)config), (int)job.getNumberOfWorkers(), (int)restartCount);
            jmWorkerAgent.startThreaded();
            workerController = jmWorkerAgent.getJMWorkerController();
            workerStatusUpdater = jmWorkerAgent.getStatusUpdater();
            senderToDriver = jmWorkerAgent.getDriverAgent();
        }
        if (ZKContext.isZooKeeperServerUsed((Config)config) && (!job.getDriverClassName().isEmpty() || CheckpointingContext.isCheckpointingEnabled((Config)config))) {
            jmWorkerAgent = JMWorkerAgent.createJMWorkerAgent((Config)config, (JobMasterAPI.WorkerInfo)workerInfo, (String)jobMasterIP, (int)JobMasterContext.jobMasterPort((Config)config), (int)job.getNumberOfWorkers(), (int)restartCount);
            jmWorkerAgent.startThreaded();
            zkWorkerController.setCheckpointingClient((CheckpointingClient)jmWorkerAgent.getCheckpointClient());
            senderToDriver = jmWorkerAgent.getDriverAgent();
            zkWorkerController.addJMFailureListener(new IJobMasterFailureListener(){

                public void jmFailed() {
                }

                public void jmRestarted(String jobMasterAddress) {
                    LOG.info("JobMaster restarted. Worker will try to reconnect and re-register.");
                    jmWorkerAgent.reconnect(jobMasterAddress);
                }
            });
        }
        initialized = true;
        return true;
    }

    public static IWorkerController getWorkerController() {
        return workerController;
    }

    public static IWorkerStatusUpdater getWorkerStatusUpdater() {
        return workerStatusUpdater;
    }

    public static synchronized ISenderToDriver getSenderToDriver() {
        return senderToDriver;
    }

    public static boolean addWorkerFailureListener(IWorkerFailureListener workerFailureListener) {
        failureListener = workerFailureListener;
        if (zkWorkerController != null) {
            return zkWorkerController.addFailureListener(workerFailureListener);
        }
        if (jmWorkerAgent != null) {
            return JMWorkerAgent.addWorkerFailureListener((IWorkerFailureListener)workerFailureListener);
        }
        return false;
    }

    public static IWorkerFailureListener getFailureListener() {
        return failureListener;
    }

    public static boolean addAllJoinedListener(IAllJoinedListener allJoinedListener) {
        if (mpiWC) {
            mpiWorkerController.addAllJoinedListener(allJoinedListener);
            return true;
        }
        if (ZKContext.isZooKeeperServerUsed((Config)config)) {
            return zkWorkerController.addAllJoinedListener(allJoinedListener);
        }
        if (jmWorkerAgent != null) {
            return JMWorkerAgent.addAllJoinedListener((IAllJoinedListener)allJoinedListener);
        }
        return false;
    }

    public static boolean addReceiverFromDriver(IReceiverFromDriver receiverFromDriver) {
        if (mpiWC) {
            return false;
        }
        if (job.getDriverClassName().isEmpty()) {
            return false;
        }
        if (jmWorkerAgent != null) {
            return JMWorkerAgent.addReceiverFromDriver((IReceiverFromDriver)receiverFromDriver);
        }
        return false;
    }

    public static boolean addScalerListener(IScalerListener scalerListener) {
        if (mpiWC) {
            return false;
        }
        if (ZKContext.isZooKeeperServerUsed((Config)config)) {
            return zkWorkerController.addScalerListener(scalerListener);
        }
        if (jmWorkerAgent != null) {
            return JMWorkerAgent.addScalerListener((IScalerListener)scalerListener);
        }
        return false;
    }

    public static boolean addJMFailureListener(IJobMasterFailureListener jobMasterListener) {
        if (zkWorkerController != null) {
            zkWorkerController.addJMFailureListener(jobMasterListener);
            return true;
        }
        return false;
    }

    public static void close() {
        if (jmWorkerAgent != null) {
            jmWorkerAgent.close();
        }
        if (zkWorkerController != null) {
            zkWorkerController.close();
            ZKUtils.closeClient();
        }
    }

    static {
        mpiWC = false;
    }
}

