/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.core;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.scheduler.ILauncher;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.LauncherException;
import edu.iu.dsc.tws.api.scheduler.Twister2JobState;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingContext;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.RequestObjectBuilder;
import edu.iu.dsc.tws.rsched.uploaders.localfs.LocalFileSystemUploader;
import edu.iu.dsc.tws.rsched.uploaders.scp.ScpContext;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import edu.iu.dsc.tws.rsched.utils.TarGzipPacker;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceAllocator {
    public static final Logger LOG = Logger.getLogger(ResourceAllocator.class.getName());
    private JobAPI.Job job;
    private Config config;

    public ResourceAllocator(Config config, JobAPI.Job job) {
        this.config = config;
        this.job = job;
    }

    public static Config loadConfig(Map<String, Object> cfg) {
        String twister2Home = System.getProperty("twister2_home");
        String configDir = System.getProperty("config_dir");
        String clusterType = System.getProperty("cluster_type");
        String jobJar = System.getProperty("job_file");
        String jobType = System.getProperty("job_type");
        Boolean debug = Boolean.valueOf(System.getProperty("debug"));
        Map<String, Object> environmentProperties = JobUtils.readCommandLineOpts();
        if (environmentProperties.containsKey("twister2_home")) {
            twister2Home = (String)environmentProperties.get("config_dir");
        }
        if (environmentProperties.containsKey("config_dir")) {
            configDir = (String)environmentProperties.get("config_dir");
        }
        if (environmentProperties.containsKey("cluster_type")) {
            clusterType = (String)environmentProperties.get("cluster_type");
        }
        if (environmentProperties.containsKey("job_file")) {
            jobJar = (String)environmentProperties.get("job_file");
        }
        if (environmentProperties.containsKey("job_type")) {
            jobType = (String)environmentProperties.get("job_type");
        }
        if (configDir == null) {
            configDir = twister2Home + "/conf";
        }
        Config cnfg = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)clusterType);
        LOG.log(Level.INFO, String.format("Loaded configuration with twister2_home: %s and configuration: %s and cluster: %s", twister2Home, configDir, clusterType));
        return Config.newBuilder().putAll(cnfg).put(SchedulerContext.TWISTER2_HOME.getKey(), (Object)twister2Home).put("twister2.cluster.type", (Object)clusterType).put("job_file", (Object)jobJar).put("job_type", (Object)jobType).put("debug", (Object)debug).putAll(environmentProperties).putAll(cfg).build();
    }

    public static Config getDefaultConfig() {
        return ResourceAllocator.loadConfig(new HashMap<String, Object>());
    }

    private String prepareJobFiles() {
        String jobJarFile = SchedulerContext.userJobJarFile((Config)this.config);
        if (jobJarFile == null) {
            throw new RuntimeException("Job file cannot be null");
        }
        Path tempDirPath = null;
        String tempDirPrefix = "twister2-" + this.job.getJobName() + "-";
        try {
            String jobArchiveTemp = SchedulerContext.jobArchiveTempDirectory((Config)this.config);
            tempDirPath = jobArchiveTemp != null ? Files.createTempDirectory(Paths.get(jobArchiveTemp, new String[0]), tempDirPrefix, new FileAttribute[0]) : Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp directory with the prefix: " + tempDirPrefix, e);
        }
        String tempDirPathString = tempDirPath.toString();
        if (!SchedulerContext.copySystemPackage((Config)this.config)) {
            LOG.log(Level.INFO, "No need to copy the systems package");
        } else {
            String twister2CorePackage = SchedulerContext.systemPackageUrl((Config)this.config);
            if (twister2CorePackage == null) {
                throw new RuntimeException("Core package is not specified in the configuration");
            }
            LOG.log(Level.INFO, String.format("Copy core package: %s to %s", twister2CorePackage, tempDirPathString));
            try {
                FileUtils.copyFileToDirectory(twister2CorePackage, tempDirPathString);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy the core package", e);
            }
        }
        TarGzipPacker packer = TarGzipPacker.createTarGzipPacker(tempDirPathString, this.config);
        if (packer == null) {
            throw new RuntimeException("Failed to created the archive file.");
        }
        String jobJarFileName = Paths.get(jobJarFile, new String[0]).getFileName().toString();
        JobAPI.JobFormat.Builder format = JobAPI.JobFormat.newBuilder();
        boolean ziped = false;
        String jobType = SchedulerContext.userJobType((Config)this.config);
        if ("jar".equals(jobType)) {
            format.setType(JobAPI.JobFormatType.JAR);
        } else if ("java_zip".equals(jobType)) {
            format.setType(JobAPI.JobFormatType.JAVA_ZIP);
            ziped = true;
        } else if ("python".equals(jobType)) {
            format.setType(JobAPI.JobFormatType.PYTHON);
        } else if ("python_zip".equals(jobType)) {
            ziped = true;
            format.setType(JobAPI.JobFormatType.PYTHON_ZIP);
        }
        format.setJobFile(jobJarFileName);
        this.job = JobAPI.Job.newBuilder((JobAPI.Job)this.job).setJobFormat(format).build();
        String jobDescFileName = SchedulerContext.createJobDescriptionFileName((String)this.job.getJobId());
        boolean added = packer.addFileToArchive(jobDescFileName, this.job.toByteArray());
        if (!added) {
            throw new RuntimeException("Failed to add the job description file to the archive: " + jobDescFileName);
        }
        added = !ziped ? packer.addFileToArchive(jobJarFile) : packer.addZipToArchive(jobJarFile);
        if (!added) {
            throw new RuntimeException("Failed to add the job jar file to the archive: " + jobJarFile);
        }
        String confDir = SchedulerContext.conf((Config)this.config);
        added = packer.addDirectoryToArchive(confDir);
        if (!added) {
            throw new RuntimeException("Failed to add the conf dir to the archive: " + confDir);
        }
        String commonConfDir = SchedulerContext.commonConfDir((Config)this.config);
        added = packer.addDirectoryToArchive(commonConfDir);
        if (!added) {
            throw new RuntimeException("Failed to add the conf dir to the archive: " + commonConfDir);
        }
        packer.close();
        LOG.log(Level.INFO, "Archive file created: " + packer.getArchiveFileName());
        this.config = Config.newBuilder().putAll(this.config).put("job_file", (Object)jobJarFileName).put("temporary.packages.path", (Object)tempDirPathString).build();
        return tempDirPathString;
    }

    public Twister2JobState submitJob() {
        this.checkUploaderAndLauncherClasses();
        String jobDirectory = this.prepareJobFiles();
        IUploader uploader = this.uploadJobPackage();
        ILauncher launcher = this.initializeLauncher();
        Twister2JobState launchState = launcher.launch(this.job);
        if (!launchState.isRequestGranted()) {
            launcher.close();
            if (!SchedulerContext.isLocalFileSystemUploader((Config)this.config)) {
                uploader.undo();
            }
            this.clearTemporaryFiles(jobDirectory);
            return launchState;
        }
        if (!uploader.complete()) {
            LOG.log(Level.SEVERE, "Transferring the job package failed.\n++++++++++++++++++ Aborting submission ++++++++++++++++++");
            launcher.killJob(this.job.getJobId());
            launchState.setRequestGranted(false);
            launcher.close();
            this.clearTemporaryFiles(jobDirectory);
            return launchState;
        }
        launcher.close();
        if (CheckpointingContext.isCheckpointingEnabled((Config)this.config) && !SchedulerContext.isLocalFileSystemUploader((Config)this.config)) {
            LocalFileSystemUploader localUploader = new LocalFileSystemUploader();
            localUploader.initialize(this.config, this.job.getJobId());
            URI savedPackage = localUploader.uploadPackage(jobDirectory);
            LOG.info("Saved Job Package to Directory: " + savedPackage.getPath());
        }
        if (!CheckpointingContext.isCheckpointingEnabled((Config)this.config) && SchedulerContext.clusterType((Config)this.config).equals("standalone") && SchedulerContext.isLocalFileSystemUploader((Config)this.config)) {
            uploader.undo();
        }
        this.clearTemporaryFiles(jobDirectory);
        return launchState;
    }

    public Twister2JobState resubmitJob() {
        ILauncher launcher;
        Twister2JobState launchState;
        this.checkUploaderAndLauncherClasses();
        IUploader uploader = null;
        if (!SchedulerContext.isLocalFileSystemUploader((Config)this.config)) {
            uploader = this.uploadJobPackage();
        }
        if (!(launchState = (launcher = this.initializeLauncher()).launch(this.job)).isRequestGranted()) {
            launcher.close();
            if (uploader != null) {
                uploader.undo();
            }
            return launchState;
        }
        if (uploader != null && !uploader.complete()) {
            LOG.log(Level.SEVERE, "Transferring the job package failed.\n++++++++++++++++++ Aborting submission ++++++++++++++++++");
            launcher.killJob(this.job.getJobId());
            launchState.setRequestGranted(false);
            launcher.close();
            return launchState;
        }
        launcher.close();
        return launchState;
    }

    private void checkUploaderAndLauncherClasses() {
        String uploaderClass = SchedulerContext.uploaderClass((Config)this.config);
        if (uploaderClass == null) {
            throw new RuntimeException("The uploader class must be specified");
        }
    }

    private IUploader uploadJobPackage() {
        String scpServerAdress;
        IUploader uploader;
        String uploaderClass = SchedulerContext.uploaderClass((Config)this.config);
        ClassLoader classLoader = ResourceAllocator.class.getClassLoader();
        try {
            uploader = (IUploader)ReflectionUtils.newInstance((ClassLoader)classLoader, (String)uploaderClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new UploaderException(String.format("Failed to instantiate uploader class '%s'", uploaderClass), (Throwable)e);
        }
        LOG.fine("Initialize uploader");
        uploader.initialize(this.config, this.job.getJobId());
        LOG.fine("Calling uploader to upload the job package");
        long start = System.currentTimeMillis();
        String jobDirectory = SchedulerContext.temporaryPackagesPath((Config)this.config);
        URI packageURI = uploader.uploadPackage(jobDirectory);
        long delay = System.currentTimeMillis() - start;
        LOG.info("Job package upload started. It took: " + delay + "ms");
        String scpPath = scpServerAdress = ScpContext.scpConnection(this.config);
        if (packageURI != null) {
            scpPath = scpPath + ":" + packageURI.toString() + "/";
        }
        LOG.fine("SCP PATH to copy files from: " + scpPath);
        this.config = Config.newBuilder().putAll(this.config).put("twister2.packages.path", (Object)scpPath).put("twister2.job.package.uri", (Object)packageURI).build();
        return uploader;
    }

    private ILauncher initializeLauncher() {
        ILauncher launcher;
        String launcherClass = SchedulerContext.launcherClass((Config)this.config);
        ClassLoader classLoader = ResourceAllocator.class.getClassLoader();
        try {
            launcher = (ILauncher)ReflectionUtils.newInstance((ClassLoader)classLoader, (String)launcherClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new LauncherException(String.format("Failed to instantiate launcher class '%s'", launcherClass), (Throwable)e);
        }
        launcher.initialize(this.config);
        return launcher;
    }

    public void clearTemporaryFiles(String jobDirectory) {
        if (Context.isKubernetesCluster((Config)this.config) && SchedulerContext.uploaderClass((Config)this.config).equals("edu.iu.dsc.tws.rsched.uploaders.k8s.K8sUploader") && RequestObjectBuilder.uploadMethod.equals("client-to-pods")) {
            return;
        }
        Path jobPackagePath = Paths.get(jobDirectory, new String[0]);
        if (Files.notExists(jobPackagePath, new LinkOption[0])) {
            LOG.severe("Job Package directory does not exist: " + jobDirectory);
        } else {
            FileUtils.deleteDir(jobDirectory);
            LOG.log(Level.INFO, "CLEANED TEMPORARY DIRECTORY......:" + jobDirectory);
        }
    }

    public static void killJob(String jobID, Config cnfg) {
        IUploader uploader;
        String uploaderClass;
        ILauncher launcher;
        String launcherClass = SchedulerContext.launcherClass((Config)cnfg);
        if (launcherClass == null) {
            throw new RuntimeException("The launcher class must be specified");
        }
        ClassLoader classLoader = ResourceAllocator.class.getClassLoader();
        try {
            launcher = (ILauncher)ReflectionUtils.newInstance((ClassLoader)classLoader, (String)launcherClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new LauncherException(String.format("Failed to instantiate launcher class '%s'", launcherClass), (Throwable)e);
        }
        launcher.initialize(cnfg);
        boolean killed = launcher.killJob(jobID);
        if (!killed) {
            LOG.log(Level.SEVERE, "Could not kill the job");
        }
        if ((uploaderClass = SchedulerContext.uploaderClass((Config)cnfg)) == null) {
            throw new RuntimeException("The uploader class must be specified");
        }
        try {
            uploader = (IUploader)ReflectionUtils.newInstance((ClassLoader)classLoader, (String)uploaderClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new UploaderException(String.format("Failed to instantiate uploader class '%s'", uploaderClass), (Throwable)e);
        }
        uploader.initialize(cnfg, jobID);
        uploader.undo();
        launcher.close();
        uploader.close();
        if (KubernetesContext.isKubernetesCluster((Config)cnfg)) {
            KubernetesController.close();
        }
        if (CheckpointingContext.isCheckpointingEnabled((Config)cnfg) && !SchedulerContext.uploaderClass((Config)cnfg).equals("edu.iu.dsc.tws.rsched.uploaders.localfs.LocalFileSystemUploader")) {
            LocalFileSystemUploader localUploader = new LocalFileSystemUploader();
            localUploader.initialize(cnfg, jobID);
            localUploader.undo();
        }
    }
}

