/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.utils;

import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResourceSchedulerUtils {
    private static final Logger LOG = Logger.getLogger(ResourceSchedulerUtils.class.getName());

    private ResourceSchedulerUtils() {
    }

    public static boolean setupWorkingDirectory(String jobName, String workingDirectory, String corePackageName, String jobPackageURI, boolean isVerbose) {
        return ResourceSchedulerUtils.setupWorkingDirectory(jobName, workingDirectory, corePackageName, jobPackageURI, isVerbose, true);
    }

    public static boolean setupWorkingDirectory(String jobId, String workingDirectory, String corePackageName, String jobPackageURI, boolean isVerbose, boolean copyCore) {
        String corePackagePath = Paths.get(jobPackageURI, corePackageName).toString();
        String corePackageDestination = Paths.get(workingDirectory, jobId, corePackageName).toString();
        String dst = Paths.get(workingDirectory, jobId).toString();
        LOG.info(String.format("Downloading package %s to %s", jobPackageURI, dst));
        try {
            FileUtils.copyDirectory(jobPackageURI, dst);
        }
        catch (IOException e) {
            LOG.severe(String.format("Failed to copy the file from uploaded place %s to working directory %s", jobPackageURI, dst));
        }
        if (copyCore && !ResourceSchedulerUtils.extractPackage(dst, corePackageDestination, true, isVerbose)) {
            LOG.severe(String.format("Failed to extract the core package %s to directory %s", corePackagePath, dst));
            return false;
        }
        ProcessUtils.extractPackageWithoutDir(workingDirectory + "/" + jobId + "/twister2-job.tar.gz", workingDirectory + "/" + jobId, false, false);
        return true;
    }

    public static boolean extractPackage(String workingDirectory, String packageDestination, boolean isDeletePackage, boolean isVerbose) {
        if (!ProcessUtils.extractPackage(packageDestination, workingDirectory, isVerbose, false)) {
            LOG.severe("Failed to extract package.");
            return false;
        }
        if (isDeletePackage && !FileUtils.deleteFile(packageDestination)) {
            LOG.warning("Failed to delete the package: " + packageDestination);
        }
        return true;
    }

    public static String getHostIP() {
        String hostIP = ResourceSchedulerUtils.getOutgoingHostIP();
        if (hostIP != null) {
            return hostIP;
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Exception when getting local host address: ", e);
            return null;
        }
    }

    public static String getOutgoingHostIP() {
        String string;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress("google.com", 80));
            string = socket.getLocalAddress().getHostAddress();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Could not connect to google.com to get localHost IP.", e);
                return null;
            }
        }
        socket.close();
        return string;
    }
}

