/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.localfs;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.uploaders.localfs.FsContext;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalFileSystemUploader
implements IUploader {
    private static final Logger LOG = Logger.getLogger(LocalFileSystemUploader.class.getName());
    private String destinationDirectory;

    public void initialize(Config config, JobAPI.Job job) {
        this.destinationDirectory = FsContext.uploaderJobDirectory(config);
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        File file = new File(sourceLocation);
        boolean fileExists = file.isDirectory();
        if (!fileExists) {
            throw new UploaderException(String.format("Job package does not exist at '%s'", sourceLocation));
        }
        String directoryName = file.getName();
        Path filePath = Paths.get(this.destinationDirectory, new String[0]);
        File parentDirectory = filePath.toFile();
        assert (parentDirectory != null);
        if (!parentDirectory.exists()) {
            LOG.log(Level.INFO, String.format("Working directory does not exist. Creating it now at %s", parentDirectory.getPath()));
            if (!parentDirectory.mkdirs()) {
                throw new UploaderException(String.format("Failed to create directory for topology package at %s", parentDirectory.getPath()));
            }
        }
        if (fileExists = new File(filePath.toString()).isFile()) {
            LOG.fine(String.format("Target job package already exists at '%s'. Overwriting it now", filePath.toString()));
        }
        LOG.log(Level.INFO, String.format("Copying job directory at '%s' to target working directory '%s'", sourceLocation, filePath.toString()));
        try {
            FileUtils.copyDirectory(sourceLocation, this.destinationDirectory);
            return new URI(this.destinationDirectory);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid file path for topology package destination: " + this.destinationDirectory, e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to copy directory %s to %s", filePath.toString(), this.destinationDirectory));
        }
    }

    public boolean undo(Config cnfg, String jobID) {
        LOG.info("Clean uploaded jar");
        File file = new File(this.destinationDirectory);
        return file.delete();
    }

    public void close() {
    }
}

