/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.k8s;

import com.google.gson.reflect.TypeToken;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.RequestObjectBuilder;
import edu.iu.dsc.tws.rsched.uploaders.k8s.UploaderToPod;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Watch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class K8sUploader
extends Thread
implements IUploader {
    private static final Logger LOG = Logger.getLogger(K8sUploader.class.getName());
    public static final long MAX_WAIT_TIME_FOR_POD_START = 300000L;
    private CoreV1Api coreApi;
    private ApiClient apiClient;
    private edu.iu.dsc.tws.api.config.Config config;
    private String namespace;
    private JobAPI.Job job;
    private String jobID;
    private String localJobPackageFile;
    private List<String> webServerPodNames;
    private static boolean uploadToWebServers;
    private ArrayList<String> podNames;
    private HashMap<String, UploaderToPod> initialPodUploaders = new HashMap();
    private ArrayList<UploaderToPod> uploaders = new ArrayList();
    private ArrayList<UploaderToPod> uploadersToWebServers = new ArrayList();
    private Watch<V1Pod> watcher;
    private boolean stopUploader = false;
    private long watcherStartTime = System.currentTimeMillis();

    public void initialize(edu.iu.dsc.tws.api.config.Config cnfg, JobAPI.Job jb) {
        this.config = cnfg;
        this.namespace = KubernetesContext.namespace(this.config);
        this.job = jb;
        this.jobID = this.job.getJobId();
        this.webServerPodNames = KubernetesController.getUploaderWebServerPods(this.namespace, KubernetesContext.uploaderWebServerLabel(this.config));
        uploadToWebServers = this.webServerPodNames.size() != 0;
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        this.localJobPackageFile = sourceLocation + "/" + SchedulerContext.jobPackageFileName((edu.iu.dsc.tws.api.config.Config)this.config);
        this.start();
        if (uploadToWebServers) {
            String uri = KubernetesContext.uploaderWebServer(this.config) + "/" + JobUtils.createJobPackageFileName(this.jobID);
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                LOG.log(Level.SEVERE, "Can not generate URI for uploader web server: " + uri, e);
                throw new UploaderException("Can not generate URI for download link: " + uri, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void run() {
        this.createApiInstances();
        if (uploadToWebServers) {
            this.startUploadersToWebServers();
        } else {
            this.watchPodsStartUploaders();
            RequestObjectBuilder.setUploadMethod("client-to-pods");
        }
    }

    private void createApiInstances() {
        try {
            this.apiClient = Config.defaultClient();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating ApiClient: ", e);
            throw new RuntimeException(e);
        }
        OkHttpClient httpClient = this.apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build();
        this.apiClient.setHttpClient(httpClient);
        Configuration.setDefaultApiClient((ApiClient)this.apiClient);
        this.coreApi = new CoreV1Api(this.apiClient);
    }

    private void startUploadersToWebServers() {
        String targetFile = KubernetesUtils.jobPackageFullPath(this.config, this.jobID);
        for (String webServerPodName : this.webServerPodNames) {
            UploaderToPod uploader = new UploaderToPod(this.namespace, webServerPodName, this.localJobPackageFile, targetFile);
            uploader.start();
            this.uploadersToWebServers.add(uploader);
        }
    }

    private boolean completeFileTransfersToWebServers() {
        boolean allTransferred = true;
        for (UploaderToPod uploader : this.uploadersToWebServers) {
            try {
                uploader.join();
                if (uploader.packageTransferred()) continue;
                LOG.log(Level.SEVERE, "Job Package is not transferred to the web server pod: " + uploader.getPodName());
                allTransferred = false;
                break;
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
            }
        }
        if (!allTransferred) {
            for (UploaderToPod uploader : this.uploadersToWebServers) {
                uploader.cancelTransfer();
            }
        }
        return allTransferred;
    }

    private void watchPodsStartUploaders() {
        this.podNames = KubernetesUtils.generatePodNames(this.job);
        if (!JobMasterContext.jobMasterRunsInClient((edu.iu.dsc.tws.api.config.Config)this.config)) {
            this.podNames.add(KubernetesUtils.createJobMasterPodName(this.job.getJobId()));
        }
        String jobPodsLabel = KubernetesUtils.createJobPodsLabelWithKey(this.jobID);
        String targetFile = "/twister2-memory-dir/" + JobUtils.createJobPackageFileName(this.jobID);
        Integer timeoutSeconds = Integer.MAX_VALUE;
        String podPhase = "Running";
        try {
            this.watcher = Watch.createWatch((ApiClient)this.apiClient, (Call)this.coreApi.listNamespacedPodCall(this.namespace, null, null, null, null, jobPodsLabel, null, null, timeoutSeconds, Boolean.TRUE, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods to get the IPs: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        try {
            for (Watch.Response item : this.watcher) {
                if (!this.stopUploader) {
                    if (item.object == null || !((V1Pod)item.object).getMetadata().getName().startsWith(this.jobID) || !podPhase.equals(((V1Pod)item.object).getStatus().getPhase())) continue;
                    String podName = ((V1Pod)item.object).getMetadata().getName();
                    if (((V1Pod)item.object).getMetadata().getDeletionTimestamp() != null) continue;
                    UploaderToPod uploader = new UploaderToPod(this.namespace, podName, this.localJobPackageFile, targetFile);
                    uploader.start();
                    if (this.podNames.contains(podName)) {
                        this.podNames.remove(podName);
                        this.initialPodUploaders.put(podName, uploader);
                        continue;
                    }
                    this.uploaders.add(uploader);
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            if (this.stopUploader) {
                LOG.fine("Uploader is stopped.");
                return;
            }
            throw e;
        }
        this.closeWatcher();
    }

    public boolean complete() {
        if (uploadToWebServers) {
            return this.completeFileTransfersToWebServers();
        }
        while (!this.podNames.isEmpty()) {
            long duration = System.currentTimeMillis() - this.watcherStartTime;
            if (duration > 300000L) {
                LOG.log(Level.SEVERE, "Max wait time limit has been reached and not all pods started.");
                return false;
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
            }
        }
        boolean allTransferred = true;
        for (Map.Entry<String, UploaderToPod> entry : this.initialPodUploaders.entrySet()) {
            try {
                entry.getValue().join();
                if (entry.getValue().packageTransferred()) continue;
                LOG.log(Level.SEVERE, "Job Package is not transferred to the pod: " + entry.getKey());
                allTransferred = false;
                break;
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
            }
        }
        if (!allTransferred) {
            for (Map.Entry<String, UploaderToPod> entry : this.initialPodUploaders.entrySet()) {
                entry.getValue().cancelTransfer();
            }
        }
        if (!JobUtils.isJobScalable(this.config, this.job) || !allTransferred) {
            this.stopUploader();
        }
        return allTransferred;
    }

    private void closeWatcher() {
        if (this.watcher == null) {
            return;
        }
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
        this.watcher = null;
    }

    public void stopUploader() {
        this.stopUploader = true;
        this.closeWatcher();
        for (Map.Entry<String, UploaderToPod> entry : this.initialPodUploaders.entrySet()) {
            entry.getValue().cancelTransfer();
        }
        for (UploaderToPod uploader : this.uploaders) {
            uploader.cancelTransfer();
        }
    }

    public boolean undo(edu.iu.dsc.tws.api.config.Config cnfg, String jbID) {
        this.stopUploader();
        return false;
    }

    public void close() {
    }
}

