/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.IController;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPICommand;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIContext;
import edu.iu.dsc.tws.rsched.schedulers.standalone.SlurmCommand;
import edu.iu.dsc.tws.rsched.schedulers.standalone.StandaloneCommand;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MPIController
implements IController {
    private static final Logger LOG = Logger.getLogger(MPIController.class.getName());
    private final boolean isVerbose;
    private Config config;
    private String workingDirectory;
    private boolean standalone = true;
    private MPICommand command;

    MPIController(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void initialize(Config mConfig) {
        this.config = Config.transform((Config)mConfig);
        this.workingDirectory = MPIContext.workingDirectory(this.config);
        LOG.log(Level.INFO, "Working directory: " + this.workingDirectory);
        this.standalone = "standalone".equals(MPIContext.mpiMode(mConfig));
        this.command = this.standalone ? new StandaloneCommand(mConfig, this.workingDirectory) : new SlurmCommand(mConfig, this.workingDirectory);
    }

    public void close() {
    }

    public boolean start(JobAPI.Job job) {
        if (job == null || job.getNumberOfWorkers() == 0) {
            LOG.log(Level.SEVERE, "No container requested. Can't schedule");
            return false;
        }
        long containers = job.getNumberOfWorkers();
        LOG.log(Level.INFO, String.format("Launching job in %s scheduler with no of workers = %d", MPIContext.clusterType((Config)this.config), containers));
        String jobDirectory = Paths.get(this.workingDirectory, job.getJobId()).toString();
        boolean jobCreated = this.createJob(this.workingDirectory, jobDirectory, job);
        if (!jobCreated) {
            LOG.log(Level.SEVERE, "Failed to create job");
        } else {
            LOG.log(Level.FINE, "Job created successfully");
        }
        return jobCreated;
    }

    public boolean kill(JobAPI.Job job) {
        String[] killCommand = this.command.killCommand();
        StringBuilder stderr = new StringBuilder();
        this.runProcess(this.workingDirectory, killCommand, stderr);
        if (!stderr.toString().equals("")) {
            LOG.log(Level.SEVERE, "Failed to kill the job");
        }
        return false;
    }

    public boolean createJob(String jobWorkingDirectory, String twister2Home, JobAPI.Job job) {
        List<String> cmds = this.command.mpiCommand(jobWorkingDirectory, job);
        ArrayList<String> transformedArgs = new ArrayList<String>();
        for (int i = 0; i < cmds.size(); ++i) {
            String arg = cmds.get(i);
            if (arg == null || arg.trim().equals("")) {
                transformedArgs.add("\"\"");
                continue;
            }
            transformedArgs.add(arg);
        }
        Object[] cmdArray = transformedArgs.toArray(new String[0]);
        LOG.log(Level.FINE, "Executing job [" + jobWorkingDirectory + "]:", Arrays.toString(cmdArray));
        StringBuilder stderr = new StringBuilder();
        return this.runProcess(twister2Home, (String[])cmdArray, stderr);
    }

    protected boolean runProcess(String jobWorkingDirectory, String[] slurmCmd, StringBuilder stderr) {
        File file = jobWorkingDirectory == null ? null : new File(jobWorkingDirectory);
        return 0 == ProcessUtils.runSyncProcess(false, slurmCmd, stderr, file, true);
    }
}

