/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIContext;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MPICommand {
    private static final Logger LOG = Logger.getLogger(MPICommand.class.getName());
    protected String workingDirectory;
    protected Config config;

    public MPICommand(Config cfg, String workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.config = cfg;
    }

    protected List<String> readFromFile(String filename) {
        Path path = new File(filename).toPath();
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<String> tempResult = Files.readAllLines(path);
            if (tempResult != null) {
                result.addAll(tempResult);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read from file. ", e);
        }
        return result;
    }

    protected String getScriptPath() {
        return new File(MPIContext.conf((Config)this.config), MPIContext.mpiShellScript(this.config)).getPath();
    }

    protected abstract String[] killCommand();

    protected Map<String, Object> mpiCommandArguments(Config cfg, JobAPI.Job job) {
        HashMap<String, Object> commands = new HashMap<String, Object>();
        int numberOfWorkers = job.getNumberOfWorkers();
        if (JobMasterContext.isJobMasterUsed((Config)this.config) && !JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
            ++numberOfWorkers;
        }
        commands.put("procs", numberOfWorkers);
        String jobClassPath = JobUtils.jobClassPath(cfg, job, this.workingDirectory);
        LOG.log(Level.FINE, "Job class path: " + jobClassPath);
        String systemClassPath = JobUtils.systemClassPath(cfg);
        String classPath = jobClassPath + ":" + systemClassPath;
        commands.put("classpath", classPath);
        commands.put("java_props", "");
        commands.put("container_class", job.getWorkerClassName());
        return commands;
    }

    int getMemory(JobAPI.Job job) {
        int memory = 256;
        int mem = job.getComputeResource(0).getRamMegaBytes();
        if (mem > 0) {
            memory = mem;
        }
        return memory;
    }

    protected abstract List<String> mpiCommand(String var1, JobAPI.Job var2);
}

