/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos.driver;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosController;
import java.util.logging.Logger;

public class MesosScaler
implements IScalerPerCluster {
    private static final Logger LOG = Logger.getLogger(MesosScaler.class.getName());
    private JobAPI.Job job;
    private Config config;
    private MesosController mesosController;
    private String scalableSSName;
    private int replicas;
    private int workersPerPod;
    private int computeResourceIndex;
    private String frameworkId;

    public MesosScaler(Config config, JobAPI.Job job, MesosController mesosController) {
        this.mesosController = mesosController;
        this.job = job;
        this.config = config;
        this.computeResourceIndex = job.getComputeResourceCount() - 1;
        this.replicas = job.getComputeResource(this.computeResourceIndex).getInstances();
        this.workersPerPod = job.getComputeResource(this.computeResourceIndex).getWorkersPerPod();
    }

    public boolean isScalable() {
        boolean computeResourceScalable = this.job.getComputeResource(this.job.getComputeResourceCount() - 1).getScalable();
        if (!computeResourceScalable) {
            return false;
        }
        return !SchedulerContext.useOpenMPI((Config)this.config);
    }

    public boolean scaleUpWorkers(int instancesToAdd) {
        return true;
    }

    public boolean scaleDownWorkers(int instancesToRemove) {
        return true;
    }

    public void setFrameWorkId(String id) {
        this.frameworkId = id;
    }
}

