/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.K8sEnvVariables;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.RequestObjectBuilder;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1EmptyDirVolumeSource;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarSource;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1ObjectFieldSelector;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public final class JobMasterRequestObject {
    private static final Logger LOG = Logger.getLogger(JobMasterRequestObject.class.getName());
    private static Config config;
    private static String jobID;
    private static String encodedNodeInfoList;
    private static long jobPackageFileSize;

    private JobMasterRequestObject() {
    }

    public static void init(Config cnfg, String jID, long jpFileSize) {
        config = cnfg;
        jobID = jID;
        jobPackageFileSize = jpFileSize;
    }

    public static V1StatefulSet createStatefulSetObject(String nodeInfoListStr) {
        if (config == null) {
            LOG.severe("JobMasterRequestObject.init method has not been called.");
            return null;
        }
        encodedNodeInfoList = nodeInfoListStr;
        V1StatefulSet statefulSet = new V1StatefulSet();
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(KubernetesUtils.createJobMasterStatefulSetName(jobID));
        statefulSet.setMetadata(meta);
        V1StatefulSetSpec setSpec = new V1StatefulSetSpec();
        setSpec.serviceName(KubernetesUtils.createJobMasterServiceName(jobID));
        setSpec.setReplicas(Integer.valueOf(1));
        V1LabelSelector selector = new V1LabelSelector();
        String jobMasterServiceLabel = KubernetesUtils.createJobMasterServiceLabel(jobID);
        selector.putMatchLabelsItem("app", jobMasterServiceLabel);
        setSpec.setSelector(selector);
        V1PodTemplateSpec template = JobMasterRequestObject.constructPodTemplate();
        setSpec.setTemplate(template);
        statefulSet.setSpec(setSpec);
        return statefulSet;
    }

    public static V1PodTemplateSpec constructPodTemplate() {
        V1PodTemplateSpec template = new V1PodTemplateSpec();
        V1ObjectMeta templateMetaData = new V1ObjectMeta();
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("app", KubernetesUtils.createJobMasterServiceLabel(jobID));
        String jobPodsLabel = KubernetesUtils.createJobPodsLabel(jobID);
        labels.put("twister2-job-pods", jobPodsLabel);
        String jobMasterRoleLabel = KubernetesUtils.createJobMasterRoleLabel(jobID);
        labels.put("twister2-role", jobMasterRoleLabel);
        templateMetaData.setLabels(labels);
        template.setMetadata(templateMetaData);
        V1PodSpec podSpec = new V1PodSpec();
        podSpec.setTerminationGracePeriodSeconds(Long.valueOf(1L));
        ArrayList<V1Volume> volumes = new ArrayList<V1Volume>();
        V1Volume memoryVolume = new V1Volume();
        memoryVolume.setName("twister2-memory-dir");
        V1EmptyDirVolumeSource volumeSource1 = new V1EmptyDirVolumeSource();
        volumeSource1.setMedium("Memory");
        memoryVolume.setEmptyDir(volumeSource1);
        volumes.add(memoryVolume);
        if (JobMasterContext.volatileVolumeRequested((Config)config)) {
            double vSize = JobMasterContext.volatileVolumeSize((Config)config);
            V1Volume volatileVolume = RequestObjectBuilder.createVolatileVolume(vSize);
            volumes.add(volatileVolume);
        }
        if (JobMasterContext.persistentVolumeRequested((Config)config)) {
            String claimName = KubernetesUtils.createPersistentVolumeClaimName(jobID);
            V1Volume persistentVolume = RequestObjectBuilder.createPersistentVolume(claimName);
            volumes.add(persistentVolume);
        }
        podSpec.setVolumes(volumes);
        ArrayList<V1Container> containers = new ArrayList<V1Container>();
        containers.add(JobMasterRequestObject.constructContainer());
        podSpec.setContainers(containers);
        template.setSpec(podSpec);
        return template;
    }

    public static V1Container constructContainer() {
        V1Container container = new V1Container();
        container.setName("twister2-job-master-0");
        String containerImage = KubernetesContext.twister2DockerImageForK8s(config);
        if (containerImage == null) {
            throw new RuntimeException("Container Image name is null. Config parameter: twister2.resource.kubernetes.docker.image can not be null");
        }
        container.setImage(containerImage);
        container.setImagePullPolicy(KubernetesContext.imagePullPolicy(config));
        container.setCommand(Arrays.asList("./init.sh"));
        V1ResourceRequirements resReq = new V1ResourceRequirements();
        resReq.putRequestsItem("cpu", new Quantity(JobMasterContext.jobMasterCpu((Config)config) + ""));
        resReq.putRequestsItem("memory", new Quantity(JobMasterContext.jobMasterRAM((Config)config) + "Mi"));
        container.setResources(resReq);
        ArrayList<V1VolumeMount> volumeMounts = new ArrayList<V1VolumeMount>();
        V1VolumeMount memoryVolumeMount = new V1VolumeMount();
        memoryVolumeMount.setName("twister2-memory-dir");
        memoryVolumeMount.setMountPath("/twister2-memory-dir");
        volumeMounts.add(memoryVolumeMount);
        if (JobMasterContext.volatileVolumeRequested((Config)config)) {
            V1VolumeMount volatileVolumeMount = new V1VolumeMount();
            volatileVolumeMount.setName("twister2-volatile-dir");
            volatileVolumeMount.setMountPath("/twister2-volatile");
            volumeMounts.add(volatileVolumeMount);
        }
        if (JobMasterContext.persistentVolumeRequested((Config)config)) {
            V1VolumeMount persVolumeMount = new V1VolumeMount();
            persVolumeMount.setName("persistent-volume");
            persVolumeMount.setMountPath("/persistent");
            volumeMounts.add(persVolumeMount);
        }
        container.setVolumeMounts(volumeMounts);
        V1ContainerPort port = new V1ContainerPort();
        port.name("job-master-port");
        port.containerPort(Integer.valueOf(JobMasterContext.jobMasterPort((Config)config)));
        port.setProtocol("TCP");
        container.setPorts(Arrays.asList(port));
        container.setEnv(JobMasterRequestObject.constructEnvironmentVariables());
        return container;
    }

    public static List<V1EnvVar> constructEnvironmentVariables() {
        ArrayList<V1EnvVar> envVars = new ArrayList<V1EnvVar>();
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_ID) + "").value(jobID));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.ENCODED_NODE_INFO_LIST) + "").value(encodedNodeInfoList));
        V1ObjectFieldSelector fieldSelector = new V1ObjectFieldSelector();
        fieldSelector.setFieldPath("status.hostIP");
        V1EnvVarSource varSource = new V1EnvVarSource();
        varSource.setFieldRef(fieldSelector);
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.HOST_IP) + "").valueFrom(varSource));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_PACKAGE_FILE_SIZE) + "").value(jobPackageFileSize + ""));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.CONTAINER_NAME) + "").value("twister2-job-master-0"));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.USER_JOB_JAR_FILE) + "").value(SchedulerContext.userJobJarFile((Config)config)));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.CLASS_TO_RUN) + "").value("edu.iu.dsc.tws.rsched.schedulers.k8s.master.JobMasterStarter"));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.POD_MEMORY_VOLUME) + "").value("/twister2-memory-dir"));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_ARCHIVE_DIRECTORY) + "").value("twister2-job"));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_PACKAGE_FILENAME) + "").value(JobUtils.createJobPackageFileName(jobID)));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.UPLOAD_METHOD) + "").value(RequestObjectBuilder.uploadMethod));
        String uri = null;
        if (SchedulerContext.jobPackageUri((Config)config) != null) {
            uri = SchedulerContext.jobPackageUri((Config)config).toString();
        }
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.JOB_PACKAGE_URI) + "").value(uri));
        envVars.add(new V1EnvVar().name((Object)((Object)K8sEnvVariables.LOGGER_PROPERTIES_FILE) + "").value("common/logger.properties"));
        return envVars;
    }

    public static V1Service createJobMasterServiceObject() {
        String serviceName = KubernetesUtils.createJobMasterServiceName(jobID);
        String serviceLabel = KubernetesUtils.createJobMasterServiceLabel(jobID);
        V1Service service = new V1Service();
        service.setKind("Service");
        service.setApiVersion("v1");
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(serviceName);
        service.setMetadata(meta);
        V1ServiceSpec serviceSpec = new V1ServiceSpec();
        HashMap<String, String> selectors = new HashMap<String, String>();
        selectors.put("app", serviceLabel);
        serviceSpec.setSelector(selectors);
        V1ServicePort servicePort = new V1ServicePort();
        servicePort.setName("job-master-port");
        servicePort.setPort(Integer.valueOf(JobMasterContext.jobMasterPort((Config)config)));
        servicePort.setTargetPort(new IntOrString(JobMasterContext.jobMasterPort((Config)config)));
        servicePort.setProtocol("TCP");
        serviceSpec.setPorts(Arrays.asList(servicePort));
        service.setSpec(serviceSpec);
        return service;
    }

    public static V1Service createJobMasterHeadlessServiceObject() {
        String serviceName = KubernetesUtils.createJobMasterServiceName(jobID);
        String serviceLabel = KubernetesUtils.createJobMasterServiceLabel(jobID);
        V1Service service = new V1Service();
        service.setKind("Service");
        service.setApiVersion("v1");
        V1ObjectMeta meta = new V1ObjectMeta();
        meta.setName(serviceName);
        service.setMetadata(meta);
        V1ServiceSpec serviceSpec = new V1ServiceSpec();
        serviceSpec.setClusterIP("None");
        HashMap<String, String> selectors = new HashMap<String, String>();
        selectors.put("app", serviceLabel);
        serviceSpec.setSelector(selectors);
        service.setSpec(serviceSpec);
        return service;
    }
}

