/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.utils.NodeInfoUtils;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import io.kubernetes.client.Exec;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimList;
import io.kubernetes.client.openapi.models.V1PersistentVolumeList;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetList;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import okhttp3.Response;

public class KubernetesController {
    private static final Logger LOG = Logger.getLogger(KubernetesController.class.getName());
    private String namespace;
    private static ApiClient client = null;
    private static CoreV1Api coreApi;
    private static AppsV1Api appsApi;

    public void init(String nspace) {
        this.namespace = nspace;
        KubernetesController.initApiInstances();
    }

    public static void initApiInstances() {
        try {
            client = Config.defaultClient();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating ApiClient: ", e);
            throw new RuntimeException(e);
        }
        Configuration.setDefaultApiClient((ApiClient)client);
        coreApi = new CoreV1Api();
        appsApi = new AppsV1Api(client);
    }

    public boolean existStatefulSets(List<String> statefulSetNames) {
        V1StatefulSetList setList = null;
        try {
            setList = appsApi.listNamespacedStatefulSet(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting StatefulSet list.", e);
            throw new RuntimeException(e);
        }
        for (V1StatefulSet statefulSet : setList.getItems()) {
            if (!statefulSetNames.contains(statefulSet.getMetadata().getName())) continue;
            LOG.severe("There is already a StatefulSet with the name: " + statefulSet.getMetadata().getName());
            return true;
        }
        return false;
    }

    public ArrayList<String> getStatefulSetsForJobWorkers(String jobID) {
        V1StatefulSetList setList = null;
        try {
            setList = appsApi.listNamespacedStatefulSet(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting StatefulSet list.", e);
            throw new RuntimeException(e);
        }
        ArrayList<String> ssNameList = new ArrayList<String>();
        for (V1StatefulSet statefulSet : setList.getItems()) {
            String ssName = statefulSet.getMetadata().getName();
            if (!ssName.matches(jobID + "-[0-9]+")) continue;
            ssNameList.add(ssName);
        }
        return ssNameList;
    }

    public boolean createStatefulSet(V1StatefulSet statefulSet) {
        String statefulSetName = statefulSet.getMetadata().getName();
        try {
            Response response = appsApi.createNamespacedStatefulSetCall(this.namespace, statefulSet, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + statefulSetName + "] is created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the StatefulSet [" + statefulSetName + "]: " + response);
            LOG.log(Level.SEVERE, "Submitted StatefulSet Object: " + statefulSet);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the StatefulSet: " + statefulSetName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the StatefulSet: " + statefulSetName, e);
        }
        return false;
    }

    public boolean deleteStatefulSet(String statefulSetName) {
        try {
            Integer gracePeriodSeconds = 0;
            Response response = appsApi.deleteNamespacedStatefulSetCall(statefulSetName, this.namespace, null, null, gracePeriodSeconds, null, "Foreground", null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + statefulSetName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.SEVERE, "There is no StatefulSet [" + statefulSetName + "] to delete on Kubernetes master. It may have already terminated.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when deleting the StatefulSet [" + statefulSetName + "]: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the StatefulSet: " + statefulSetName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the StatefulSet: " + statefulSetName, e);
            return false;
        }
    }

    public boolean patchStatefulSet(String ssName, int replicas) {
        ApiClient jsonPatchClient;
        String jsonPatchStr = "[{\"op\":\"replace\",\"path\":\"/spec/replicas\",\"value\":" + replicas + "}]";
        try {
            jsonPatchClient = ClientBuilder.standard().setOverridePatchFormat("application/json-patch+json").build();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error when creating patch client: " + ssName, e);
            return false;
        }
        AppsV1Api patchApi = new AppsV1Api(jsonPatchClient);
        try {
            Response response = patchApi.patchNamespacedStatefulSetScaleCall(ssName, this.namespace, (Object)new V1Patch(jsonPatchStr), null, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + ssName + "] is patched.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when patching the StatefulSet [" + ssName + "]: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when patching the StatefulSet: " + ssName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when patching the StatefulSet: " + ssName, e);
        }
        return false;
    }

    public boolean createService(V1Service service) {
        String serviceName = service.getMetadata().getName();
        try {
            Response response = coreApi.createNamespacedServiceCall(this.namespace, service, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "Service [" + serviceName + "] created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the service [" + serviceName + "]: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the service: " + serviceName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the service: " + serviceName, e);
        }
        return false;
    }

    public String existServices(List<String> serviceNames) {
        V1ServiceList serviceList = null;
        try {
            serviceList = coreApi.listNamespacedService(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting service list.", e);
            throw new RuntimeException(e);
        }
        for (V1Service service : serviceList.getItems()) {
            if (!serviceNames.contains(service.getMetadata().getName())) continue;
            return service.getMetadata().getName();
        }
        return null;
    }

    public boolean deleteService(String serviceName) {
        Integer gracePeriodsSeconds = 0;
        try {
            Response response = coreApi.deleteNamespacedServiceCall(serviceName, this.namespace, null, null, gracePeriodsSeconds, null, "Foreground", null, null).execute();
            if (response.isSuccessful()) {
                LOG.info("Service [" + serviceName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.warning("There is no Service [" + serviceName + "] to delete on Kubernetes master. It may have already been terminated.");
                return true;
            }
            LOG.severe("Error when deleting the Service [" + serviceName + "]: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the service: " + serviceName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the service: " + serviceName, e);
            return false;
        }
    }

    public String getServiceIP(String serviceName) {
        V1ServiceList serviceList = null;
        try {
            serviceList = coreApi.listNamespacedService(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting service list.", e);
            throw new RuntimeException(e);
        }
        for (V1Service service : serviceList.getItems()) {
            if (!serviceName.equals(service.getMetadata().getName())) continue;
            return service.getSpec().getClusterIP();
        }
        return null;
    }

    public static boolean runProcess(String[] command) {
        StringBuilder stderr = new StringBuilder();
        int status = ProcessUtils.runSyncProcess(false, command, stderr, new File("."), false);
        return status == 0;
    }

    public boolean existPersistentVolumeClaim(String pvcName) {
        V1PersistentVolumeClaimList pvcList = null;
        try {
            pvcList = coreApi.listNamespacedPersistentVolumeClaim(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolumeClaim list.", e);
            throw new RuntimeException(e);
        }
        for (V1PersistentVolumeClaim pvc : pvcList.getItems()) {
            if (!pvcName.equals(pvc.getMetadata().getName())) continue;
            LOG.severe("There is already a PersistentVolumeClaim with the name: " + pvcName);
            return true;
        }
        return false;
    }

    public boolean createPersistentVolumeClaim(V1PersistentVolumeClaim pvc) {
        String pvcName = pvc.getMetadata().getName();
        try {
            Response response = coreApi.createNamespacedPersistentVolumeClaimCall(this.namespace, pvc, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolumeClaim [" + pvcName + "] is created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the PersistentVolumeClaim [" + pvcName + "] Response: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolumeClaim: " + pvcName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolumeClaim: " + pvcName, e);
        }
        return false;
    }

    public boolean deletePersistentVolumeClaim(String pvcName) {
        try {
            Response response = coreApi.deleteNamespacedPersistentVolumeClaimCall(pvcName, this.namespace, null, null, null, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolumeClaim [" + pvcName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.FINE, "There is no PersistentVolumeClaim [" + pvcName + "] to delete on Kubernetes master. It may have already been deleted.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when deleting the PersistentVolumeClaim [" + pvcName + "] Response: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolumeClaim: " + pvcName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolumeClaim: " + pvcName, e);
            return false;
        }
    }

    public V1PersistentVolume getPersistentVolume(String pvName) {
        V1PersistentVolumeList pvList = null;
        try {
            pvList = coreApi.listPersistentVolume(null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolume list.", e);
            throw new RuntimeException(e);
        }
        for (V1PersistentVolume pv : pvList.getItems()) {
            if (!pvName.equals(pv.getMetadata().getName())) continue;
            return pv;
        }
        return null;
    }

    public boolean createPersistentVolume(V1PersistentVolume pv) {
        String pvName = pv.getMetadata().getName();
        try {
            Response response = coreApi.createPersistentVolumeCall(pv, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolume [" + pvName + "] is created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the PersistentVolume [" + pvName + "]: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolume: " + pvName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolume: " + pvName, e);
        }
        return false;
    }

    public boolean deletePersistentVolume(String pvName) {
        try {
            Response response = coreApi.deletePersistentVolumeCall(pvName, null, null, null, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolume [" + pvName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.WARNING, "There is no PersistentVolume [" + pvName + "] to delete on Kubernetes master. It may have already been deleted.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when deleting the PersistentVolume [" + pvName + "]: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolume: " + pvName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolume: " + pvName, e);
            return false;
        }
    }

    public boolean existSecret(String secretName) {
        V1SecretList secretList = null;
        try {
            secretList = coreApi.listNamespacedSecret(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting Secret list.", e);
            throw new RuntimeException(e);
        }
        for (V1Secret secret : secretList.getItems()) {
            if (!secretName.equalsIgnoreCase(secret.getMetadata().getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<JobMasterAPI.NodeInfo> getNodeInfo(String rackLabelKey, String datacenterLabelKey) {
        V1NodeList nodeList = null;
        try {
            nodeList = coreApi.listNode(null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting NodeList.", e);
            return null;
        }
        ArrayList<JobMasterAPI.NodeInfo> nodeInfoList = new ArrayList<JobMasterAPI.NodeInfo>();
        block2: for (V1Node node : nodeList.getItems()) {
            List addressList = node.getStatus().getAddresses();
            for (V1NodeAddress nodeAddress : addressList) {
                if (!"InternalIP".equalsIgnoreCase(nodeAddress.getType())) continue;
                String nodeIP = nodeAddress.getAddress();
                String rackName = null;
                String datacenterName = null;
                Map labelMap = node.getMetadata().getLabels();
                for (String key : labelMap.keySet()) {
                    if (key.equalsIgnoreCase(rackLabelKey)) {
                        rackName = (String)labelMap.get(key);
                    }
                    if (!key.equalsIgnoreCase(datacenterLabelKey)) continue;
                    datacenterName = (String)labelMap.get(key);
                }
                JobMasterAPI.NodeInfo nodeInfo = NodeInfoUtils.createNodeInfo((String)nodeIP, rackName, datacenterName);
                nodeInfoList.add(nodeInfo);
                continue block2;
            }
        }
        return nodeInfoList;
    }

    public static List<String> getUploaderWebServerPods(String ns, String uploaderLabel) {
        if (coreApi == null) {
            KubernetesController.initApiInstances();
        }
        V1PodList podList = null;
        try {
            podList = coreApi.listNamespacedPod(ns, null, null, null, null, uploaderLabel, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting uploader pod list.", e);
            throw new RuntimeException(e);
        }
        List<String> podNames = podList.getItems().stream().map(v1pod -> v1pod.getMetadata().getName()).collect(Collectors.toList());
        return podNames;
    }

    public boolean deleteJobPackage(List<String> uploaderPods, String jobPackageName) {
        String command = String.format("rm -f %s", jobPackageName);
        String[] fullCommand = new String[]{"bash", "-c", command};
        boolean allDeleted = true;
        for (String uploaderPod : uploaderPods) {
            try {
                Exec exec = new Exec(client);
                Process proc = exec.exec(this.namespace, uploaderPod, fullCommand, false, false);
                proc.waitFor();
                proc.destroy();
                if (proc.exitValue() == 0) {
                    LOG.info("Deleted job package from uploader web server pod: " + uploaderPod);
                    continue;
                }
                LOG.info("Could not delete the job package from uploader web server pod: " + uploaderPod + ", process exit code: " + proc.exitValue());
                allDeleted = false;
            }
            catch (ApiException e) {
                LOG.log(Level.INFO, String.format("Exception when deleting the job package from uploader web server [%s]", uploaderPod), e);
            }
            catch (IOException e) {
                LOG.log(Level.INFO, String.format("Exception when deleting the job package from uploader web server [%s]", uploaderPod), e);
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, String.format("Exception when deleting the job package from uploader web server [%s]", uploaderPod), e);
            }
        }
        return allDeleted;
    }
}

