/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.api.resource.FSPersistentVolume;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.logging.LoggingHelper;
import edu.iu.dsc.tws.common.util.JSONUtils;
import edu.iu.dsc.tws.common.util.NetworkUtils;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.master.worker.JMSenderToDriver;
import edu.iu.dsc.tws.master.worker.JMWorkerAgent;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.JobExecutionState;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.NodeInfoUtils;
import edu.iu.dsc.tws.proto.utils.WorkerInfoUtils;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadContext;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadTerminator;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIContext;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIJobWorkerController;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIWorkerController;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import mpi.Intracomm;
import mpi.MPI;
import mpi.MPIException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class MPIWorker {
    private static final Logger LOG = Logger.getLogger(MPIWorker.class.getName());
    private JMWorkerAgent masterClient;
    private Config config;
    private JobMasterAPI.WorkerInfo wInfo;

    public void finalizeMPI() {
        try {
            if (JobMasterContext.isJobMasterUsed((Config)this.config)) {
                this.closeWorker();
            }
            MPI.Finalize();
        }
        catch (MPIException mPIException) {
            // empty catch block
        }
    }

    private MPIWorker(String[] args) {
        Options cmdOptions = null;
        try {
            MPI.InitThread((String[])args, (int)MPI.THREAD_MULTIPLE);
            int rank = MPI.COMM_WORLD.getRank();
            Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
                LOG.log(Level.SEVERE, "Uncaught exception in thread " + thread + ". Finalizing this worker...", throwable);
                if (!JobMasterContext.isJobMasterUsed((Config)this.config)) {
                    throw new RuntimeException("Worker faild with exception", throwable);
                }
                JMSenderToDriver senderToDriver = JMWorkerAgent.getJMWorkerAgent().getSenderToDriver();
                Exception exception = (Exception)throwable;
                JobExecutionState.WorkerJobState workerState = JobExecutionState.WorkerJobState.newBuilder().setFailure(true).setJobName(this.config.getStringValue("twister2.job.id")).setWorkerMessage(JSONUtils.toJSONString((Object)exception)).build();
                senderToDriver.sendToDriver((Message)workerState);
                this.finalizeMPI();
            });
            cmdOptions = this.setupOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(cmdOptions, args);
            this.config = this.loadConfigurations(cmd, rank);
            LOG.log(Level.FINE, "A worker process is starting...");
            String jobId = MPIContext.jobId((Config)this.config);
            String jobDescFile = JobUtils.getJobDescriptionFilePath(jobId, this.config);
            JobAPI.Job job = JobUtils.readJobFile(null, jobDescFile);
            if (JobMasterContext.isJobMasterUsed((Config)this.config)) {
                if (!JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
                    int color = rank == 0 ? 0 : 1;
                    Intracomm comm = MPI.COMM_WORLD.split(color, rank);
                    this.wInfo = rank != 0 ? this.createWorkerInfo(this.config, comm.getRank(), job) : this.createWorkerInfo(this.config, -1, job);
                    this.broadCastMasterInformation(rank);
                    if (rank != 0) {
                        this.startWorker(this.config, rank, comm, job);
                    } else {
                        this.startMaster(this.config, rank);
                    }
                } else {
                    this.wInfo = this.createWorkerInfo(this.config, MPI.COMM_WORLD.getRank(), job);
                    this.startWorker(this.config, rank, MPI.COMM_WORLD, job);
                }
            } else {
                this.wInfo = this.createWorkerInfo(this.config, MPI.COMM_WORLD.getRank(), job);
                this.startWorkerWithoutMaster(this.config, rank, MPI.COMM_WORLD, job);
            }
        }
        catch (MPIException e) {
            LOG.log(Level.SEVERE, "Failed the MPI process", e);
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("SubmitterMain", cmdOptions);
            throw new RuntimeException("Error parsing command line options: ", e);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.log(Level.SEVERE, "Protocol buffer exception ", e);
        }
        this.finalizeMPI();
    }

    private void broadCastMasterInformation(int rank) throws MPIException, InvalidProtocolBufferException {
        byte[] workerBytes = this.wInfo.toByteArray();
        int length = workerBytes.length;
        IntBuffer countSend = MPI.newIntBuffer((int)1);
        if (rank == 0) {
            countSend.put(length);
        }
        MPI.COMM_WORLD.bcast((Object)countSend, 1, MPI.INT, 0);
        length = countSend.get(0);
        ByteBuffer sendBuffer = MPI.newByteBuffer((int)length);
        if (rank == 0) {
            sendBuffer.put(workerBytes);
        }
        MPI.COMM_WORLD.bcast((Object)sendBuffer, length, MPI.BYTE, 0);
        byte[] c = new byte[length];
        if (rank != 0) {
            sendBuffer.get(c);
            JobMasterAPI.WorkerInfo masterInfo = ((JobMasterAPI.WorkerInfo.Builder)JobMasterAPI.WorkerInfo.newBuilder().mergeFrom(c)).build();
            this.config = Config.newBuilder().putAll(this.config).put("twister2.job.master.port", (Object)masterInfo.getPort()).put("twister2.job.master.ip", (Object)masterInfo.getNodeInfo().getNodeIP()).build();
        } else {
            this.config = Config.newBuilder().putAll(this.config).put("twister2.job.master.port", (Object)this.wInfo.getPort()).put("twister2.job.master.ip", (Object)this.wInfo.getNodeInfo().getNodeIP()).build();
        }
    }

    public static void main(String[] args) {
        new MPIWorker(args);
    }

    private IWorkerController createWorkerController(JobAPI.Job job) {
        String jobMasterIP = JobMasterContext.jobMasterIP((Config)this.config);
        int jobMasterPort = JobMasterContext.jobMasterPort((Config)this.config);
        int numberOfWorkers = job.getNumberOfWorkers();
        this.masterClient = this.createMasterAgent(this.config, jobMasterIP, jobMasterPort, this.wInfo, numberOfWorkers);
        return this.masterClient.getJMWorkerController();
    }

    private JMWorkerAgent createMasterAgent(Config cfg, String masterHost, int masterPort, JobMasterAPI.WorkerInfo workerInfo, int numberContainers) {
        JobMasterAPI.WorkerState initialState = JobMasterAPI.WorkerState.STARTED;
        JMWorkerAgent jobMasterAgent = JMWorkerAgent.createJMWorkerAgent((Config)cfg, (JobMasterAPI.WorkerInfo)workerInfo, (String)masterHost, (int)masterPort, (int)numberContainers, (JobMasterAPI.WorkerState)initialState);
        LOG.log(Level.FINE, String.format("Connecting to job master %s:%d", masterHost, masterPort));
        jobMasterAgent.startThreaded();
        return jobMasterAgent;
    }

    private Options setupOptions() {
        Options options = new Options();
        Option containerClass = Option.builder((String)"c").desc("The class name of the container to launch").longOpt("container_class").hasArgs().argName("container class").required().build();
        Option configDirectory = Option.builder((String)"d").desc("The class name of the container to launch").longOpt("config_dir").hasArgs().argName("configuration directory").required().build();
        Option twister2Home = Option.builder((String)"t").desc("The class name of the container to launch").longOpt("twister2_home").hasArgs().argName("twister2 home").required().build();
        Option clusterType = Option.builder((String)"n").desc("The clustr type").longOpt("cluster_type").hasArgs().argName("cluster type").required().build();
        Option jobId = Option.builder((String)"j").desc("Job Id").longOpt("job_id").hasArgs().argName("job id").required().build();
        Option jobMasterIP = Option.builder((String)"i").desc("Job master ip").longOpt("job_master_ip").hasArgs().argName("job master ip").required().build();
        Option jobMasterPort = Option.builder((String)"p").desc("Job master ip").longOpt("job_master_port").hasArgs().argName("job master port").required().build();
        options.addOption(twister2Home);
        options.addOption(containerClass);
        options.addOption(configDirectory);
        options.addOption(clusterType);
        options.addOption(jobId);
        options.addOption(jobMasterIP);
        options.addOption(jobMasterPort);
        return options;
    }

    private Config loadConfigurations(CommandLine cmd, int id) {
        String twister2Home = cmd.getOptionValue("twister2_home");
        String container = cmd.getOptionValue("container_class");
        String configDir = cmd.getOptionValue("config_dir");
        String clusterType = cmd.getOptionValue("cluster_type");
        String jobId = cmd.getOptionValue("job_id");
        String jIp = cmd.getOptionValue("job_master_ip");
        int jPort = Integer.parseInt(cmd.getOptionValue("job_master_port"));
        LOG.log(Level.FINE, String.format("Initializing process with twister_home: %s container_class: %s config_dir: %s cluster_type: %s", twister2Home, container, configDir, clusterType));
        Config cfg = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)clusterType);
        Config workerConfig = Config.newBuilder().putAll(cfg).put(MPIContext.TWISTER2_HOME.getKey(), (Object)twister2Home).put("twister2.resource.job.worker.class", (Object)container).put("twister2.container.id", (Object)id).put("twister2.cluster.type", (Object)clusterType).build();
        String jobDescFile = JobUtils.getJobDescriptionFilePath(jobId, workerConfig);
        JobAPI.Job job = JobUtils.readJobFile(null, jobDescFile);
        Config updatedConfig = JobUtils.overrideConfigs(job, cfg);
        updatedConfig = Config.newBuilder().putAll(updatedConfig).put(MPIContext.TWISTER2_HOME.getKey(), (Object)twister2Home).put("twister2.resource.job.worker.class", (Object)container).put("twister2.container.id", (Object)id).put("twister2.job.id", (Object)jobId).put("twister2.job.object", (Object)job).put("twister2.cluster.type", (Object)clusterType).put("twister2.job.master.ip", (Object)jIp).put("twister2.job.master.port", (Object)jPort).build();
        return updatedConfig;
    }

    private void startMaster(Config cfg, int rank) {
        JobAPI.Job job = (JobAPI.Job)cfg.get("twister2.job.object");
        try {
            int port = JobMasterContext.jobMasterPort((Config)cfg);
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            LOG.log(Level.INFO, String.format("Starting the job manager: %s:%d", hostAddress, port));
            JobMasterAPI.NodeInfo jobMasterNodeInfo = null;
            IScalerPerCluster clusterScaler = null;
            JobMasterAPI.JobMasterState initialState = JobMasterAPI.JobMasterState.JM_STARTED;
            NomadTerminator nt = new NomadTerminator();
            JobMaster jobMaster = new JobMaster(cfg, hostAddress, port, (IJobTerminator)nt, job, jobMasterNodeInfo, clusterScaler, initialState);
            jobMaster.addShutdownHook(false);
            Thread jmThread = jobMaster.startJobMasterThreaded();
            try {
                if (jmThread != null) {
                    jmThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.log(Level.INFO, "Master done... ");
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Exception when getting local host address: ", e);
            throw new RuntimeException(e);
        }
        catch (Twister2Exception e) {
            LOG.log(Level.SEVERE, "Exception when starting Job master: ", e);
            throw new RuntimeException(e);
        }
    }

    private void startWorker(Config cfg, int rank, Intracomm intracomm, JobAPI.Job job) {
        try {
            String twister2Home = Context.twister2Home((Config)cfg);
            this.initLogger(cfg, intracomm.getRank(), twister2Home);
            IWorkerController wc = this.createWorkerController(job);
            MPIJobWorkerController mpiWorkerContorller = new MPIJobWorkerController(wc);
            IPersistentVolume persistentVolume = this.initPersistenceVolume(cfg, job.getJobName(), rank);
            mpiWorkerContorller.add("comm", intracomm);
            String workerClass = MPIContext.workerClass((Config)cfg);
            try {
                Object object = ReflectionUtils.newInstance((String)workerClass);
                if (!(object instanceof IWorker)) {
                    throw new RuntimeException("Cannot instantiate class: " + object.getClass());
                }
                IWorker container = (IWorker)object;
                container.execute(cfg, intracomm.getRank(), (IWorkerController)mpiWorkerContorller, persistentVolume, null);
                LOG.log(Level.FINE, "loaded worker class: " + workerClass);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.log(Level.SEVERE, String.format("failed to load the worker class %s", workerClass), e);
                throw new RuntimeException(e);
            }
            LOG.log(Level.FINE, String.format("Worker %d: the cluster is ready...", rank));
        }
        catch (MPIException e) {
            LOG.log(Level.SEVERE, "Failed to synchronize the workers at the start");
            throw new RuntimeException(e);
        }
    }

    private void startWorkerWithoutMaster(Config cfg, int rank, Intracomm intracomm, JobAPI.Job job) {
        try {
            String twister2Home = Context.twister2Home((Config)cfg);
            this.initLogger(cfg, intracomm.getRank(), twister2Home);
            Map<Integer, JobMasterAPI.WorkerInfo> infos = this.createResourcePlan(cfg, intracomm, job);
            MPIWorkerController wc = new MPIWorkerController(intracomm.getRank(), infos);
            IPersistentVolume persistentVolume = this.initPersistenceVolume(cfg, job.getJobName(), rank);
            wc.add("comm", intracomm);
            String workerClass = MPIContext.workerClass((Config)cfg);
            try {
                Object object = ReflectionUtils.newInstance((String)workerClass);
                if (!(object instanceof IWorker)) {
                    throw new RuntimeException("Cannot instantiate class: " + object.getClass());
                }
                IWorker container = (IWorker)object;
                container.execute(cfg, intracomm.getRank(), (IWorkerController)wc, persistentVolume, null);
                LOG.log(Level.FINE, "loaded worker class: " + workerClass);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.log(Level.SEVERE, String.format("failed to load the worker class %s", workerClass), e);
                throw new RuntimeException(e);
            }
            LOG.log(Level.FINE, String.format("Worker %d: the cluster is ready...", rank));
        }
        catch (MPIException e) {
            LOG.log(Level.SEVERE, "Failed to synchronize the workers at the start");
            throw new RuntimeException(e);
        }
    }

    private void closeWorker() {
        LOG.log(Level.INFO, String.format("Worker finished executing - %d", this.wInfo.getWorkerID()));
        if (this.masterClient != null) {
            this.masterClient.sendWorkerCompletedMessage();
            this.masterClient.close();
        }
    }

    public Map<Integer, JobMasterAPI.WorkerInfo> createResourcePlan(Config cfg, Intracomm intracomm, JobAPI.Job job) {
        try {
            JobMasterAPI.WorkerInfo workerInfo = this.createWorkerInfo(cfg, intracomm.getRank(), job);
            byte[] workerBytes = workerInfo.toByteArray();
            int length = workerBytes.length;
            IntBuffer countSend = MPI.newIntBuffer((int)1);
            int worldSize = intracomm.getSize();
            IntBuffer countReceive = MPI.newIntBuffer((int)worldSize);
            countSend.put(length);
            intracomm.allGather((Object)countSend, 1, MPI.INT, (Object)countReceive, 1, MPI.INT);
            int[] receiveSizes = new int[worldSize];
            int[] displacements = new int[worldSize];
            int sum = 0;
            for (int i = 0; i < worldSize; ++i) {
                receiveSizes[i] = countReceive.get(i);
                displacements[i] = sum;
                sum += receiveSizes[i];
            }
            ByteBuffer sendBuffer = MPI.newByteBuffer((int)length);
            ByteBuffer receiveBuffer = MPI.newByteBuffer((int)sum);
            sendBuffer.put(workerBytes);
            intracomm.allGatherv((Object)sendBuffer, length, MPI.BYTE, (Object)receiveBuffer, receiveSizes, displacements, MPI.BYTE);
            HashMap<Integer, JobMasterAPI.WorkerInfo> processNames = new HashMap<Integer, JobMasterAPI.WorkerInfo>();
            for (int i = 0; i < receiveSizes.length; ++i) {
                byte[] c = new byte[receiveSizes[i]];
                receiveBuffer.get(c);
                JobMasterAPI.WorkerInfo info = ((JobMasterAPI.WorkerInfo.Builder)JobMasterAPI.WorkerInfo.newBuilder().mergeFrom(c)).build();
                processNames.put(i, info);
                LOG.log(Level.FINE, String.format("Process %d name: %s", i, processNames.get(i)));
            }
            return processNames;
        }
        catch (MPIException e) {
            throw new RuntimeException("Failed to communicate", e);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failed to create worker info", e);
        }
    }

    private JobMasterAPI.WorkerInfo createWorkerInfo(Config cfg, int workerId, JobAPI.Job job) throws MPIException {
        String processName;
        try {
            processName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to get ip address", e);
        }
        JobMasterAPI.NodeInfo nodeInfo = NodeInfoUtils.createNodeInfo((String)processName, (String)"default", (String)"default");
        JobAPI.ComputeResource computeResource = JobUtils.getComputeResource(job, workerId);
        ArrayList<String> portNames = SchedulerContext.additionalPorts((Config)cfg);
        HashMap freePorts = new HashMap();
        if (portNames == null) {
            portNames = new ArrayList<String>();
        }
        portNames.add("__worker__");
        Map socketMap = NetworkUtils.findFreePorts(portNames);
        MPI.COMM_WORLD.barrier();
        AtomicBoolean closedSuccessfully = new AtomicBoolean(true);
        socketMap.forEach((k, v) -> {
            freePorts.put(k, v.getLocalPort());
            try {
                v.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e, () -> "Couldn't close opened server socket : " + k);
                closedSuccessfully.set(false);
            }
        });
        if (!closedSuccessfully.get()) {
            throw new IllegalStateException("Could not release one or more free TCP/IP ports");
        }
        Integer workerPort = (Integer)freePorts.get("__worker__");
        freePorts.remove("__worker__");
        LOG.fine("Worker info host:" + processName + ":" + workerPort);
        return WorkerInfoUtils.createWorkerInfo((int)workerId, (String)processName, (int)workerPort, (JobMasterAPI.NodeInfo)nodeInfo, (JobAPI.ComputeResource)computeResource, freePorts);
    }

    private void initLogger(Config cfg, int workerID, String logDirectory) {
        String jobWorkingDirectory = NomadContext.workingDirectory(cfg);
        String jobId = NomadContext.jobId((Config)cfg);
        String persistentJobDir = NomadContext.getLoggingSandbox(cfg) ? Paths.get(jobWorkingDirectory, jobId).toString() : logDirectory;
        if (persistentJobDir == null) {
            return;
        }
        String logDir = persistentJobDir + "/logs/worker-" + workerID;
        File directory = new File(logDir);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException("Failed to create log directory: " + logDir);
        }
        LoggingHelper.setupLogging((Config)cfg, (String)logDir, (String)("worker-" + workerID));
        LOG.fine(String.format("Logging is setup with file %s", logDir));
    }

    private IPersistentVolume initPersistenceVolume(Config cfg, String jobId, int rank) {
        File baseDir = new File(MPIContext.fileSystemMount(cfg));
        while (!baseDir.exists() && !baseDir.mkdirs()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread interrupted", e);
            }
        }
        return new FSPersistentVolume(baseDir.getAbsolutePath(), rank);
    }
}

