/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.mpi;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.ISenderToDriver;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.IWorkerStatusUpdater;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.common.logging.LoggingHelper;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.NodeInfoUtils;
import edu.iu.dsc.tws.proto.utils.WorkerInfoUtils;
import edu.iu.dsc.tws.rsched.core.WorkerRuntime;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.PodWatchUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.mpi.MPIMasterStarter;
import edu.iu.dsc.tws.rsched.schedulers.k8s.worker.K8sPersistentVolume;
import edu.iu.dsc.tws.rsched.schedulers.k8s.worker.K8sVolatileVolume;
import edu.iu.dsc.tws.rsched.schedulers.k8s.worker.K8sWorkerUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mpi.MPI;
import mpi.MPIException;

public final class MPIWorkerStarter {
    private static final Logger LOG = Logger.getLogger(MPIWorkerStarter.class.getName());
    private static Config config = null;
    private static int workerID = -1;
    private static int numberOfWorkers = -1;
    private static JobMasterAPI.WorkerInfo workerInfo;
    private static String jobID;
    private static JobAPI.Job job;
    private static JobAPI.ComputeResource computeResource;

    private MPIWorkerStarter() {
    }

    public static void main(String[] args) {
        LoggingHelper.setLoggingFormat((String)"[%1$tF %1$tT] [%4$s] [%7$s] %3$s: %5$s %6$s %n");
        String jobMasterIP = MPIMasterStarter.getJobMasterIPCommandLineArgumentValue(args[0]);
        jobID = args[1];
        String encodedNodeInfoList = args[2];
        if (jobMasterIP == null) {
            throw new RuntimeException("JobMasterIP address is null");
        }
        if (jobID == null) {
            throw new RuntimeException("jobID is null");
        }
        encodedNodeInfoList = encodedNodeInfoList.replaceAll("'", "");
        String configDir = "/twister2-memory-dir/twister2-job";
        config = K8sWorkerUtils.loadConfig(configDir);
        try {
            MPI.Init((String[])args);
            workerID = MPI.COMM_WORLD.getRank();
            numberOfWorkers = MPI.COMM_WORLD.getSize();
        }
        catch (MPIException e) {
            LOG.log(Level.SEVERE, "Could not get rank or size from MPI.COMM_WORLD", e);
            throw new RuntimeException(e);
        }
        K8sPersistentVolume pv = null;
        if (KubernetesContext.persistentVolumeRequested((Config)config)) {
            String persistentJobDir = "/persistent";
            pv = new K8sPersistentVolume(persistentJobDir, workerID);
        }
        K8sWorkerUtils.initWorkerLogger(workerID, pv, config);
        String jobDescFileName = SchedulerContext.createJobDescriptionFileName((String)jobID);
        jobDescFileName = "/twister2-memory-dir/twister2-job/" + jobDescFileName;
        job = JobUtils.readJobFile(null, jobDescFileName);
        LOG.info("Job description file is loaded: " + jobDescFileName);
        config = JobUtils.overrideConfigs(job, config);
        config = JobUtils.updateConfigs(job, config);
        config = Config.newBuilder().putAll(config).put("twister2.job.master.ip", (Object)jobMasterIP).build();
        InetAddress localHost = null;
        String podName = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Cannot get localHost.", e);
        }
        String podIP = localHost.getHostAddress();
        podName = localHost.getHostName();
        if (podName.indexOf(".") > 0) {
            podName = podName.substring(0, podName.indexOf("."));
        }
        int workerPort = KubernetesContext.workerBasePort(config) + workerID * (SchedulerContext.numberOfAdditionalPorts((Config)config) + 1);
        String nodeIP = PodWatchUtils.getNodeIP(KubernetesContext.namespace(config), jobID, podIP);
        JobMasterAPI.NodeInfo nodeInfo = null;
        if (nodeIP == null) {
            LOG.warning("Could not get nodeIP for this pod. Using podIP as nodeIP.");
            nodeInfo = NodeInfoUtils.createNodeInfo((String)podIP, null, null);
        } else {
            nodeInfo = KubernetesContext.nodeLocationsFromConfig(config) ? KubernetesContext.getNodeInfo((Config)config, (String)nodeIP) : K8sWorkerUtils.getNodeInfoFromEncodedStr(encodedNodeInfoList, nodeIP);
        }
        LOG.info(String.format("PodName: %s, NodeInfo for this worker: %s", podName, nodeInfo));
        computeResource = K8sWorkerUtils.getComputeResource(job, podName);
        Map<String, Integer> additionalPorts = K8sWorkerUtils.generateAdditionalPorts(config, workerPort);
        workerInfo = WorkerInfoUtils.createWorkerInfo((int)workerID, (String)podIP, (int)workerPort, (JobMasterAPI.NodeInfo)nodeInfo, (JobAPI.ComputeResource)computeResource, additionalPorts);
        LOG.info("Worker information summary: \nMPI Rank(workerID): " + workerID + "\nMPI Size(number of workers): " + numberOfWorkers + "\nPOD_IP: " + podIP + "\nHOSTNAME(podname): " + podName);
        JobMasterAPI.WorkerState initialState = K8sWorkerUtils.initialStateAndUpdate(config, jobID, workerInfo);
        WorkerRuntime.init(config, job, workerInfo, initialState);
        IWorkerController workerController = WorkerRuntime.getWorkerController();
        IWorkerStatusUpdater workerStatusUpdater = WorkerRuntime.getWorkerStatusUpdater();
        ISenderToDriver senderToDriver = WorkerRuntime.getSenderToDriver();
        MPIWorkerStarter.startWorker(workerController, (IPersistentVolume)pv, podName);
        workerStatusUpdater.updateWorkerStatus(JobMasterAPI.WorkerState.COMPLETED);
        try {
            MPI.Finalize();
        }
        catch (MPIException mPIException) {
            // empty catch block
        }
        WorkerRuntime.close();
    }

    public static void startWorker(IWorkerController workerController, IPersistentVolume pv, String podName) {
        IWorker worker;
        String workerClass = SchedulerContext.workerClass((Config)config);
        try {
            Object object = ReflectionUtils.newInstance((String)workerClass);
            worker = (IWorker)object;
            LOG.info("loaded worker class: " + workerClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.severe(String.format("failed to load the worker class %s", workerClass));
            throw new RuntimeException(e);
        }
        K8sVolatileVolume volatileVolume = null;
        if (computeResource.getDiskGigaBytes() > 0.0) {
            volatileVolume = new K8sVolatileVolume(jobID, workerID);
        }
        worker.execute(config, workerID, workerController, pv, (IVolatileVolume)volatileVolume);
    }

    static {
        jobID = null;
        job = null;
        computeResource = null;
    }
}

