/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.hdfs;

import edu.iu.dsc.tws.rsched.utils.ProcessUtils;

public class HdfsController {
    private final String configDir;
    private final boolean isVerbose;

    public HdfsController(String configDir, boolean isVerbose) {
        this.configDir = configDir;
        this.isVerbose = isVerbose;
    }

    public boolean exists(String filePath) {
        String command = String.format("hadoop --config %s fs -test -e %s", this.configDir, filePath);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }

    public boolean mkdirs(String dir) {
        String command = String.format("hadoop --config %s fs -mkdir -p %s", this.configDir, dir);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }

    public boolean copyFromLocalFile(String source, String destination) {
        String command = String.format("hadoop --config %s fs -copyFromLocal -f %s %s", this.configDir, source, destination);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }

    public boolean delete(String filePath) {
        String command = String.format("hadoop --config %s fs -rm %s", this.configDir, filePath);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }
}

