/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.nomad;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.scheduler.ILauncher;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadContext;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadController;
import edu.iu.dsc.tws.rsched.schedulers.nomad.master.NomadMasterStarter;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import edu.iu.dsc.tws.rsched.utils.ResourceSchedulerUtils;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NomadLauncher
implements ILauncher {
    private static final Logger LOG = Logger.getLogger(NomadController.class.getName());
    private Config config;

    public void initialize(Config cfg) {
        this.config = cfg;
    }

    public void close() {
    }

    public boolean terminateJob(String jobName) {
        LOG.log(Level.INFO, "Terminating job for cluster: ", NomadContext.clusterType((Config)this.config));
        String jobWorkingDirectory = NomadContext.workingDirectory(this.config);
        Config newConfig = Config.newBuilder().putAll(this.config).put("twister2.working_directory", (Object)jobWorkingDirectory).build();
        NomadController controller = new NomadController(true);
        controller.initialize(newConfig);
        jobWorkingDirectory = Paths.get(jobWorkingDirectory, jobName).toAbsolutePath().toString();
        String jobDescFile = JobUtils.getJobDescriptionFilePath(jobWorkingDirectory, jobName, this.config);
        JobAPI.Job job = JobUtils.readJobFile(null, jobDescFile);
        return controller.kill(job);
    }

    public boolean launch(JobAPI.Job job) {
        LOG.log(Level.INFO, "Launching job for cluster {0}", NomadContext.clusterType((Config)this.config));
        NomadMasterStarter master = new NomadMasterStarter();
        master.initialize(job, this.config);
        boolean start = master.launch();
        if (!this.terminateJob(job.getJobName())) {
            LOG.log(Level.INFO, "Failed to terminate job: " + job.getJobName());
        }
        return start;
    }

    private boolean setupWorkingDirectory(JobAPI.Job job, String jobWorkingDirectory) {
        String corePackage = NomadContext.corePackageFileName((Config)this.config);
        String jobPackage = NomadContext.jobPackageFileName((Config)this.config);
        LOG.log(Level.INFO, "Core Package is ......: " + corePackage);
        LOG.log(Level.INFO, "Job Package is ......: " + jobPackage);
        String jobPackageURI = NomadContext.jobPackageUri((Config)this.config).toString();
        LOG.log(Level.INFO, "Job Package URI is ......: " + jobPackageURI);
        return ResourceSchedulerUtils.setupWorkingDirectory(job.getJobName(), jobWorkingDirectory, corePackage, jobPackageURI, Context.verbose((Config)this.config));
    }
}

