/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos.mpi;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.worker.JMWorkerAgent;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerController;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerLogger;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.Inet4Address;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mpi.MPI;
import mpi.MPIException;

public final class MesosMPIWorkerStarter {
    public static final Logger LOG = Logger.getLogger(MesosMPIWorkerStarter.class.getName());
    private static Config config;
    private static String jobName;
    private static JMWorkerAgent jobMasterAgent;
    private static int workerID;
    private static int numberOfWorkers;
    private static int resourceIndex;
    private static int startingPort;

    private MesosMPIWorkerStarter() {
    }

    public static void main(String[] args) {
        try {
            MPI.Init((String[])args);
            workerID = MPI.COMM_WORLD.getRank();
            numberOfWorkers = MPI.COMM_WORLD.getSize();
            System.out.println("Worker ranking..:" + workerID + " Number of workers..:" + numberOfWorkers);
        }
        catch (MPIException e) {
            LOG.log(Level.SEVERE, "Could not get rank or size from mpi.COMM_WORLD", e);
            throw new RuntimeException(e);
        }
        jobName = args[0];
        String twister2Home = Paths.get("", new String[0]).toAbsolutePath().toString();
        String configDir = "twister2-job";
        config = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)"mesos");
        MesosWorkerLogger logger = new MesosWorkerLogger(config, "/persistent-volume/logs", "worker" + workerID);
        logger.initLogging();
        MesosWorkerController workerController = null;
        Map<String, Integer> additionalPorts = MesosWorkerUtils.generateAdditionalPorts(config, startingPort);
        try {
            JobAPI.Job job = JobUtils.readJobFile(null, "twister2-job/" + jobName + ".job");
            config = JobUtils.overrideConfigs(job, config);
            config = JobUtils.updateConfigs(job, config);
            JobAPI.ComputeResource computeResource = JobUtils.getComputeResource(job, resourceIndex);
            LOG.info("in worker starter...... job worker count:" + job.getNumberOfWorkers());
            workerController = new MesosWorkerController(config, job, Inet4Address.getLocalHost().getHostAddress(), 2023, workerID, computeResource, additionalPorts);
            workerController.initializeWithZooKeeper();
        }
        catch (Exception e) {
            LOG.severe("Error " + e.getMessage());
        }
        String jobMasterIP = args[1];
        LOG.info("JobMaster IP..: " + jobMasterIP);
        LOG.info("Worker ID..: " + workerID);
        int jobMasterPort = JobMasterContext.jobMasterPort((Config)config);
        MesosMPIWorkerStarter.startJobMasterAgent(workerController.getWorkerInfo(), jobMasterIP, jobMasterPort);
        LOG.info("\nWorker Controller\nWorker ID..: " + workerController.getWorkerInfo().getWorkerID() + "\nIP address..: " + workerController.getWorkerInfo().getWorkerIP());
        MesosMPIWorkerStarter.startWorker(workerController, null);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOG.info("sleep exception" + e.getMessage());
        }
        try {
            MPI.Finalize();
        }
        catch (MPIException ignore) {
            LOG.info("MPI Finalize Exception" + ignore.getMessage());
        }
        MesosMPIWorkerStarter.closeWorker();
    }

    public static void startJobMasterAgent(JobMasterAPI.WorkerInfo workerInfo, String jobMasterIP, int jobMasterPort) {
        LOG.info("JobMaster IP..: " + jobMasterIP);
        LOG.info("NETWORK INFO..: " + workerInfo.getWorkerIP().toString());
        jobMasterAgent = JMWorkerAgent.createJMWorkerAgent((Config)config, (JobMasterAPI.WorkerInfo)workerInfo, (String)jobMasterIP, (int)jobMasterPort, (int)numberOfWorkers);
        jobMasterAgent.startThreaded(false);
    }

    public static void startWorker(IWorkerController workerController, IPersistentVolume pv) {
        IWorker worker;
        JobAPI.Job job = JobUtils.readJobFile(null, "twister2-job/" + jobName + ".job");
        String workerClass = job.getWorkerClassName();
        LOG.info("Worker class---->>>" + workerClass);
        try {
            Object object = ReflectionUtils.newInstance((String)workerClass);
            worker = (IWorker)object;
            LOG.info("Loaded worker class..: " + workerClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.severe(String.format("Failed to load the worker class %s", workerClass));
            throw new RuntimeException(e);
        }
        IVolatileVolume volatileVolume = null;
        worker.execute(config, workerID, workerController, pv, volatileVolume);
    }

    public static void closeWorker() {
        jobMasterAgent.sendWorkerCompletedMessage();
        jobMasterAgent.close();
    }

    static {
        resourceIndex = 0;
        startingPort = 30000;
    }
}

