/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.uploader;

import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploaderToPod
extends Thread {
    private static final Logger LOG = Logger.getLogger(UploaderToPod.class.getName());
    public static final long MAX_FILE_TRANSFER_TRY_COUNT = 3L;
    public static final long SLEEP_INTERVAL_BETWEEN_TRANSFER_ATTEMPTS = 200L;
    private String namespace;
    private String podName;
    private String jobPackageFile;
    private boolean transferred = false;
    private boolean cancelFileTransfer = false;

    public UploaderToPod(String namespace, String podName, String jobPackageFile) {
        this.namespace = namespace;
        this.podName = podName;
        this.jobPackageFile = jobPackageFile;
    }

    public boolean packageTransferred() {
        return this.transferred;
    }

    public void cancelTransfer() {
        this.cancelFileTransfer = true;
    }

    @Override
    public void run() {
        String[] copyCommand = KubernetesUtils.createCopyCommand(this.jobPackageFile, this.namespace, this.podName);
        int attemptCount = 0;
        while (!this.transferred && (long)attemptCount < 3L && !this.cancelFileTransfer) {
            this.transferred = KubernetesController.runProcess(copyCommand);
            if (this.transferred) {
                LOG.info("Job Package: " + this.jobPackageFile + " transferred to the pod: " + this.podName);
                continue;
            }
            if ((long)(++attemptCount) == 3L) {
                LOG.warning("Job Package: " + this.jobPackageFile + " could not be transferred to the pod: " + this.podName + ". Attempt count: " + attemptCount + "\nExecuted command: " + this.copyCommandAsString(copyCommand));
                continue;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
            }
        }
    }

    private String copyCommandAsString(String[] copyCommand) {
        String copyStr = "";
        for (String cmd : copyCommand) {
            copyStr = copyStr + cmd + " ";
        }
        return copyStr;
    }
}

