/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.uploader;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.uploader.UploaderToPod;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Watch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploaderForJob
extends Thread {
    private static final Logger LOG = Logger.getLogger(UploaderForJob.class.getName());
    public static final long MAX_WAIT_TIME_FOR_POD_START = 300000L;
    private CoreV1Api coreApi;
    private ApiClient apiClient;
    private edu.iu.dsc.tws.api.config.Config config;
    private String namespace;
    private JobAPI.Job job;
    private String jobName;
    private String jobPackageFile;
    private ArrayList<String> podNames;
    private HashMap<String, UploaderToPod> initialPodUploaders = new HashMap();
    private ArrayList<UploaderToPod> uploaders = new ArrayList();
    private Watch<V1Pod> watcher;
    private boolean stopUploader = false;
    private long watcherStartTime = System.currentTimeMillis();

    public UploaderForJob(edu.iu.dsc.tws.api.config.Config config, JobAPI.Job job, String jobPackageFile) {
        this.config = config;
        this.namespace = KubernetesContext.namespace(config);
        this.job = job;
        this.jobName = job.getJobName();
        this.jobPackageFile = jobPackageFile;
        this.podNames = KubernetesUtils.generatePodNames(job);
        if (!JobMasterContext.jobMasterRunsInClient((edu.iu.dsc.tws.api.config.Config)config)) {
            this.podNames.add(KubernetesUtils.createJobMasterPodName(job.getJobName()));
        }
    }

    @Override
    public void run() {
        this.createApiInstances();
        this.watchScaledUpPods();
    }

    private void createApiInstances() {
        try {
            this.apiClient = Config.defaultClient();
            this.apiClient.getHttpClient().setReadTimeout(0L, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating ApiClient: ", e);
            throw new RuntimeException(e);
        }
        Configuration.setDefaultApiClient((ApiClient)this.apiClient);
        this.coreApi = new CoreV1Api(this.apiClient);
    }

    private void watchScaledUpPods() {
        String jobPodsLabel = KubernetesUtils.createJobPodsLabelWithKey(this.jobName);
        Integer timeoutSeconds = Integer.MAX_VALUE;
        String podPhase = "Running";
        try {
            this.watcher = Watch.createWatch((ApiClient)this.apiClient, (Call)this.coreApi.listNamespacedPodCall(this.namespace, null, null, null, null, jobPodsLabel, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods to get the IPs: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        try {
            for (Watch.Response item : this.watcher) {
                if (!this.stopUploader) {
                    if (item.object == null || !((V1Pod)item.object).getMetadata().getName().startsWith(this.jobName) || !podPhase.equals(((V1Pod)item.object).getStatus().getPhase())) continue;
                    String podName = ((V1Pod)item.object).getMetadata().getName();
                    if (((V1Pod)item.object).getMetadata().getDeletionTimestamp() != null) continue;
                    UploaderToPod uploader = new UploaderToPod(this.namespace, podName, this.jobPackageFile);
                    uploader.start();
                    if (this.podNames.contains(podName)) {
                        this.podNames.remove(podName);
                        this.initialPodUploaders.put(podName, uploader);
                        continue;
                    }
                    this.uploaders.add(uploader);
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            if (this.stopUploader) {
                LOG.fine("Uploader is stopped.");
                return;
            }
            throw e;
        }
        this.closeWatcher();
    }

    public boolean completeFileTransfers() {
        while (!this.podNames.isEmpty()) {
            long duration = System.currentTimeMillis() - this.watcherStartTime;
            if (duration > 300000L) {
                LOG.log(Level.SEVERE, "Max wait time limit has been reached and not all pods started.");
                return false;
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
            }
        }
        boolean allTransferred = true;
        for (Map.Entry<String, UploaderToPod> entry : this.initialPodUploaders.entrySet()) {
            try {
                entry.getValue().join();
                if (entry.getValue().packageTransferred()) continue;
                LOG.log(Level.SEVERE, "Job Package is not transferred to the pod: " + entry.getKey());
                allTransferred = false;
                break;
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
            }
        }
        if (!allTransferred) {
            for (Map.Entry<String, UploaderToPod> entry : this.initialPodUploaders.entrySet()) {
                entry.getValue().cancelTransfer();
            }
        }
        if (!this.isJobScalable() || !allTransferred) {
            this.stopUploader();
        }
        return allTransferred;
    }

    private void closeWatcher() {
        if (this.watcher == null) {
            return;
        }
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
        this.watcher = null;
    }

    public void stopUploader() {
        this.stopUploader = true;
        this.closeWatcher();
        for (Map.Entry<String, UploaderToPod> entry : this.initialPodUploaders.entrySet()) {
            entry.getValue().cancelTransfer();
        }
        for (UploaderToPod uploader : this.uploaders) {
            uploader.cancelTransfer();
        }
    }

    public boolean isJobScalable() {
        if (this.job.getDriverClassName().isEmpty()) {
            return false;
        }
        boolean computeResourceScalable = this.job.getComputeResource(this.job.getComputeResourceCount() - 1).getScalable();
        if (!computeResourceScalable) {
            return false;
        }
        return !SchedulerContext.useOpenMPI((edu.iu.dsc.tws.api.config.Config)this.config);
    }
}

