/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.master;

import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import java.util.ArrayList;

public class JobTerminator
implements IJobTerminator {
    private KubernetesController controller;
    private String namespace;

    public JobTerminator(String namespace) {
        this.namespace = namespace;
        this.controller = new KubernetesController();
        this.controller.init(namespace);
    }

    public boolean terminateJob(String jobName) {
        ArrayList<String> ssNameLists = this.controller.getStatefulSetsForJobWorkers(jobName);
        boolean ssForWorkersDeleted = true;
        for (String ssName : ssNameLists) {
            ssForWorkersDeleted &= this.controller.deleteStatefulSet(ssName);
        }
        String serviceName = KubernetesUtils.createServiceName(jobName);
        boolean serviceForWorkersDeleted = this.controller.deleteService(serviceName);
        String jobMasterServiceName = KubernetesUtils.createJobMasterServiceName(jobName);
        boolean serviceForJobMasterDeleted = this.controller.deleteService(jobMasterServiceName);
        String pvcName = KubernetesUtils.createPersistentVolumeClaimName(jobName);
        boolean pvcDeleted = this.controller.deletePersistentVolumeClaim(pvcName);
        String jobMasterStatefulSetName = KubernetesUtils.createJobMasterStatefulSetName(jobName);
        boolean ssForJobMasterDeleted = this.controller.deleteStatefulSet(jobMasterStatefulSetName);
        return ssForWorkersDeleted && serviceForWorkersDeleted && serviceForJobMasterDeleted && pvcDeleted && ssForJobMasterDeleted;
    }
}

