/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.common.driver.IScalerPerCluster;
import edu.iu.dsc.tws.common.logging.LoggingHelper;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.K8sEnvVariables;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.driver.K8sScaler;
import edu.iu.dsc.tws.rsched.schedulers.k8s.master.JobTerminator;
import edu.iu.dsc.tws.rsched.schedulers.k8s.worker.K8sWorkerUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public final class JobMasterStarter {
    private static final Logger LOG = Logger.getLogger(JobMasterStarter.class.getName());

    private JobMasterStarter() {
    }

    public static void main(String[] args) {
        LoggingHelper.setLoggingFormat((String)"[%1$tF %1$tT] [%4$s] [%7$s] %3$s: %5$s %6$s %n");
        String jobName = System.getenv((Object)((Object)K8sEnvVariables.JOB_NAME) + "");
        String encodedNodeInfoList = System.getenv((Object)((Object)K8sEnvVariables.ENCODED_NODE_INFO_LIST) + "");
        String hostIP = System.getenv((Object)((Object)K8sEnvVariables.HOST_IP) + "");
        String configDir = "/twister2-memory-dir/twister2-job";
        Config config = K8sWorkerUtils.loadConfig(configDir);
        config = K8sWorkerUtils.unsetWorkerIDAssigment(config);
        String jobDescFileName = SchedulerContext.createJobDescriptionFileName((String)jobName);
        jobDescFileName = "/twister2-memory-dir/twister2-job/" + jobDescFileName;
        JobAPI.Job job = JobUtils.readJobFile(null, jobDescFileName);
        LOG.info("Job description file is loaded: " + jobDescFileName);
        config = JobUtils.overrideConfigs(job, config);
        config = JobUtils.updateConfigs(job, config);
        K8sWorkerUtils.initLogger(config, "jobMaster");
        LOG.info("JobMaster is starting. Current time: " + System.currentTimeMillis());
        LOG.info("Number of configuration parameters: " + config.size());
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot get localHost.", e);
        }
        String podIP = localHost.getHostAddress();
        JobMasterAPI.NodeInfo nodeInfo = KubernetesContext.nodeLocationsFromConfig(config) ? KubernetesContext.getNodeInfo((Config)config, (String)hostIP) : K8sWorkerUtils.getNodeInfoFromEncodedStr(encodedNodeInfoList, hostIP);
        LOG.info("NodeInfo for JobMaster: " + nodeInfo);
        String namespace = KubernetesContext.namespace(config);
        JobTerminator jobTerminator = new JobTerminator(namespace);
        KubernetesController controller = new KubernetesController();
        controller.init(KubernetesContext.namespace(config));
        K8sScaler k8sScaler = new K8sScaler(config, job, controller);
        JobMaster jobMaster = new JobMaster(config, podIP, (IJobTerminator)jobTerminator, job, nodeInfo, (IScalerPerCluster)k8sScaler);
        jobMaster.addShutdownHook(false);
        jobMaster.startJobMasterBlocking();
    }
}

