/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1Event;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.models.V1PodList;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Watch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PodWatchUtils {
    private static final Logger LOG = Logger.getLogger(PodWatchUtils.class.getName());
    public static CoreV1Api coreApi;
    public static ApiClient apiClient;

    private PodWatchUtils() {
    }

    public static void createApiInstances() {
        try {
            apiClient = Config.defaultClient();
            apiClient.getHttpClient().setReadTimeout(0L, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating ApiClient: ", e);
            throw new RuntimeException(e);
        }
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        coreApi = new CoreV1Api(apiClient);
    }

    public static HashMap<String, String> discoverRunningPodIPs(ArrayList<String> podNames, String namespace, String labelSelector, int timeout) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        HashMap<String, String> podNamesIPs = new HashMap<String, String>();
        String phase = "Running";
        Integer timeoutSeconds = timeout;
        Watch watch = null;
        try {
            watch = Watch.createWatch((ApiClient)apiClient, (Call)coreApi.listNamespacedPodCall(namespace, null, null, null, null, labelSelector, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods to get the IPs: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        boolean allPodsRunning = false;
        for (Watch.Response item : watch) {
            if (item.object == null || !podNames.contains(((V1Pod)item.object).getMetadata().getName()) || !phase.equals(((V1Pod)item.object).getStatus().getPhase())) continue;
            String podName = ((V1Pod)item.object).getMetadata().getName();
            podNames.remove(podName);
            String podIP = ((V1Pod)item.object).getStatus().getPodIP();
            podNamesIPs.put(podName, podIP);
            LOG.info("Received pod Running event for the pod: " + podName + "[" + podIP + "]");
            if (podNames.size() != 0) continue;
            allPodsRunning = true;
            break;
        }
        try {
            watch.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
        return allPodsRunning ? podNamesIPs : null;
    }

    public static boolean watchPodsToRunning(String namespace, String jobName, HashMap<String, Boolean> pods, int timeout) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        String phase = "Running";
        String serviceLabel = KubernetesUtils.createServiceLabelWithKey(jobName);
        Integer timeoutSeconds = timeout;
        Watch watch = null;
        try {
            watch = Watch.createWatch((ApiClient)apiClient, (Call)coreApi.listNamespacedPodCall(namespace, null, null, null, null, serviceLabel, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods for the job: " + jobName + "\nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        boolean allPodsRunning = false;
        for (Watch.Response item : watch) {
            if (item.object == null || !pods.containsKey(((V1Pod)item.object).getMetadata().getName()) || !phase.equals(((V1Pod)item.object).getStatus().getPhase())) continue;
            String podName = ((V1Pod)item.object).getMetadata().getName();
            pods.put(podName, true);
            LOG.log(Level.INFO, "Received pod Running event for the pod: " + podName);
            if (!PodWatchUtils.allTrue(pods.values())) continue;
            LOG.log(Level.INFO, "All pods reached Running state.");
            allPodsRunning = true;
            break;
        }
        try {
            watch.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
        return allPodsRunning;
    }

    private static boolean allTrue(Collection<Boolean> flags) {
        for (Boolean flag : flags) {
            if (flag.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean watchPodsToStarting(String namespace, String jobName, HashMap<String, Boolean> pods, int timeout) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        String workerRoleLabel = KubernetesUtils.createWorkerRoleLabelWithKey(jobName);
        String reason = "Started";
        Integer timeoutSeconds = timeout;
        Watch watch = null;
        try {
            watch = Watch.createWatch((ApiClient)apiClient, (Call)coreApi.listNamespacedEventCall(namespace, null, null, null, null, null, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Event>>(){}.getType());
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Can not start event watcher for the namespace: " + namespace, e);
            return false;
        }
        boolean allPodsStarted = false;
        for (Watch.Response item : watch) {
            String involvedPod;
            if (item.object == null || !reason.equals(((V1Event)item.object).getReason()) || !pods.containsKey(involvedPod = ((V1Event)item.object).getInvolvedObject().getName()) || pods.get(involvedPod).booleanValue()) continue;
            pods.put(involvedPod, true);
            LOG.log(Level.INFO, "Container started event received for the pod: " + involvedPod);
            if (!PodWatchUtils.allTrue(pods.values())) continue;
            LOG.log(Level.INFO, "All pods reached Starting state.");
            allPodsStarted = true;
            break;
        }
        try {
            watch.close();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Exception when clsoing the watcher.", e);
        }
        return allPodsStarted;
    }

    public static String getNodeIP(String namespace, String jobName, String podIP) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        String workerRoleLabel = KubernetesUtils.createWorkerRoleLabelWithKey(jobName);
        V1PodList podList = null;
        try {
            podList = coreApi.listNamespacedPod(namespace, null, null, null, null, workerRoleLabel, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PodList.", e);
            throw new RuntimeException(e);
        }
        for (V1Pod pod : podList.getItems()) {
            if (!podIP.equals(pod.getStatus().getPodIP())) continue;
            return pod.getStatus().getHostIP();
        }
        return null;
    }

    public static void testGetPodList(String namespace) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        LOG.info("Getting the pod list for the namespace: " + namespace);
        V1PodList list = null;
        try {
            list = coreApi.listNamespacedPod(namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            String logMessage = "Exception when getting the pod list: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        LOG.info("Number of pods in the received list: " + list.getItems().size());
        for (V1Pod item : list.getItems()) {
            LOG.info(item.getMetadata().getName());
        }
    }

    public static void testWatchPods(String namespace, String jobName, int timeout) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        String jobPodsLabel = KubernetesUtils.createJobPodsLabelWithKey(jobName);
        LOG.info("Starting the watcher for: " + namespace + ", " + jobName);
        Integer timeoutSeconds = timeout;
        Watch watch = null;
        try {
            watch = Watch.createWatch((ApiClient)apiClient, (Call)coreApi.listNamespacedPodCall(namespace, null, null, null, null, jobPodsLabel, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods to get the IPs: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        int eventCounter = 0;
        LOG.info("Getting watcher events.");
        for (Watch.Response item : watch) {
            if (item.object != null) {
                LOG.info(eventCounter++ + "-Received watch event: " + ((V1Pod)item.object).getMetadata().getName() + ", " + ((V1Pod)item.object).getStatus().getPodIP() + ", " + ((V1Pod)item.object).getStatus().getPhase());
            } else {
                LOG.info("Received an event with item.object null.");
            }
            if (eventCounter != 5) continue;
            break;
        }
        if (eventCounter != 5) {
            LOG.info("Has not received 5 events. Probably timeout limit has been reached.");
        }
        try {
            watch.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
    }

    public static String getIpByWatchingPodToRunning(String namespace, String podName, int timeout) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        String podNameLabel = "statefulset.kubernetes.io/pod-name=" + podName;
        String podPhase = "Running";
        LOG.info("Starting the watcher for: " + namespace + ", " + podName);
        Integer timeoutSeconds = timeout;
        Watch watch = null;
        try {
            watch = Watch.createWatch((ApiClient)apiClient, (Call)coreApi.listNamespacedPodCall(namespace, null, null, null, null, podNameLabel, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods to get the IPs: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        int eventCounter = 0;
        LOG.info("Getting watcher events.");
        String podIP = null;
        for (Watch.Response item : watch) {
            if (item.object != null) {
                LOG.info(eventCounter++ + "-Received watch event: " + ((V1Pod)item.object).getMetadata().getName() + ", " + ((V1Pod)item.object).getStatus().getPodIP() + ", " + ((V1Pod)item.object).getStatus().getPhase());
                if (!podPhase.equalsIgnoreCase(((V1Pod)item.object).getStatus().getPhase())) continue;
                podIP = ((V1Pod)item.object).getStatus().getPodIP();
                break;
            }
            LOG.info("Received an event with item.object null.");
        }
        try {
            watch.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
        return podIP;
    }

    public static String getJobMasterIpByWatchingPodToRunning(String namespace, String jobName, int timeout) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        String jobMasterRoleLabel = KubernetesUtils.createJobMasterRoleLabelWithKey(jobName);
        String podPhase = "Running";
        LOG.finest("Starting the watcher for the job master: " + namespace + ", " + jobName + ", " + jobMasterRoleLabel);
        Integer timeoutSeconds = timeout;
        Watch watch = null;
        try {
            watch = Watch.createWatch((ApiClient)apiClient, (Call)coreApi.listNamespacedPodCall(namespace, null, null, null, null, jobMasterRoleLabel, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods to get the IPs: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        int eventCounter = 0;
        LOG.finest("Getting watcher events.");
        String podIP = null;
        for (Watch.Response item : watch) {
            if (item.object != null) {
                LOG.info(eventCounter++ + "-Received watch event: " + ((V1Pod)item.object).getMetadata().getName() + ", " + ((V1Pod)item.object).getStatus().getPodIP() + ", " + ((V1Pod)item.object).getStatus().getPhase());
                if (!podPhase.equalsIgnoreCase(((V1Pod)item.object).getStatus().getPhase())) continue;
                podIP = ((V1Pod)item.object).getStatus().getPodIP();
                break;
            }
            LOG.warning("Received an event with item.object null.");
        }
        try {
            watch.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
        return podIP;
    }

    public static ArrayList<String> getWorkerIPsByWatchingPodsToRunning(String namespace, String jobName, int numberOfPods, int timeout) {
        if (apiClient == null || coreApi == null) {
            PodWatchUtils.createApiInstances();
        }
        String workerRoleLabel = KubernetesUtils.createWorkerRoleLabelWithKey(jobName);
        String podPhase = "Running";
        LOG.finest("Starting the watcher for the worker pods: " + namespace + ", " + jobName + ", " + workerRoleLabel);
        Integer timeoutSeconds = timeout;
        Watch watch = null;
        try {
            watch = Watch.createWatch((ApiClient)apiClient, (Call)coreApi.listNamespacedPodCall(namespace, null, null, null, null, workerRoleLabel, null, null, timeoutSeconds, Boolean.TRUE, null, null), (Type)new TypeToken<Watch.Response<V1Pod>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the pods to get the IPs: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        int eventCounter = 0;
        LOG.finest("Getting watcher events.");
        ArrayList<String> ipList = new ArrayList<String>();
        for (Watch.Response item : watch) {
            if (item.object == null || !podPhase.equalsIgnoreCase(((V1Pod)item.object).getStatus().getPhase())) continue;
            LOG.info(eventCounter++ + "-Received pod Running event: " + ((V1Pod)item.object).getMetadata().getName() + ", " + ((V1Pod)item.object).getStatus().getPodIP() + ", " + ((V1Pod)item.object).getStatus().getPhase());
            ipList.add(((V1Pod)item.object).getStatus().getPodIP());
            if (ipList.size() != numberOfPods) continue;
            break;
        }
        try {
            watch.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception closing watcher.", e);
        }
        if (ipList.size() == numberOfPods) {
            return ipList;
        }
        StringBuffer ips = new StringBuffer();
        for (String ip : ipList) {
            ips.append(ip).append(", ");
        }
        LOG.severe("Could not get IPs of all worker pods. List of retrieved IPs: " + ips.toString());
        return null;
    }
}

