/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.squareup.okhttp.Response;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.utils.NodeInfoUtils;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.AppsV1beta2Api;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1DeleteOptions;
import io.kubernetes.client.models.V1Node;
import io.kubernetes.client.models.V1NodeAddress;
import io.kubernetes.client.models.V1NodeList;
import io.kubernetes.client.models.V1PersistentVolume;
import io.kubernetes.client.models.V1PersistentVolumeClaim;
import io.kubernetes.client.models.V1PersistentVolumeClaimList;
import io.kubernetes.client.models.V1PersistentVolumeList;
import io.kubernetes.client.models.V1Secret;
import io.kubernetes.client.models.V1SecretList;
import io.kubernetes.client.models.V1Service;
import io.kubernetes.client.models.V1ServiceList;
import io.kubernetes.client.models.V1beta2StatefulSet;
import io.kubernetes.client.models.V1beta2StatefulSetList;
import io.kubernetes.client.util.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KubernetesController {
    private static final Logger LOG = Logger.getLogger(KubernetesController.class.getName());
    private String namespace;
    private ApiClient client = null;
    private CoreV1Api coreApi;
    private AppsV1beta2Api appsApi;

    public void init(String nspace) {
        this.namespace = nspace;
        this.createApiInstances();
    }

    public void createApiInstances() {
        try {
            this.client = Config.defaultClient();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating ApiClient: ", e);
            throw new RuntimeException(e);
        }
        Configuration.setDefaultApiClient((ApiClient)this.client);
        this.coreApi = new CoreV1Api();
        this.appsApi = new AppsV1beta2Api(this.client);
    }

    public boolean existStatefulSets(List<String> statefulSetNames) {
        V1beta2StatefulSetList setList = null;
        try {
            setList = this.appsApi.listNamespacedStatefulSet(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting StatefulSet list.", e);
            throw new RuntimeException(e);
        }
        for (V1beta2StatefulSet statefulSet : setList.getItems()) {
            if (!statefulSetNames.contains(statefulSet.getMetadata().getName())) continue;
            LOG.severe("There is already a StatefulSet with the name: " + statefulSet.getMetadata().getName());
            return true;
        }
        return false;
    }

    public ArrayList<String> getStatefulSetsForJobWorkers(String jobName) {
        V1beta2StatefulSetList setList = null;
        try {
            setList = this.appsApi.listNamespacedStatefulSet(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting StatefulSet list.", e);
            throw new RuntimeException(e);
        }
        ArrayList<String> ssNameList = new ArrayList<String>();
        for (V1beta2StatefulSet statefulSet : setList.getItems()) {
            String ssName = statefulSet.getMetadata().getName();
            if (!ssName.matches(jobName + "-[0-9]+")) continue;
            ssNameList.add(ssName);
        }
        return ssNameList;
    }

    public boolean createStatefulSet(V1beta2StatefulSet statefulSet) {
        String statefulSetName = statefulSet.getMetadata().getName();
        try {
            Response response = this.appsApi.createNamespacedStatefulSetCall(this.namespace, statefulSet, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + statefulSetName + "] is created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the StatefulSet [" + statefulSetName + "]: " + response);
            LOG.log(Level.SEVERE, "Submitted StatefulSet Object: " + statefulSet);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the StatefulSet: " + statefulSetName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the StatefulSet: " + statefulSetName, e);
        }
        return false;
    }

    public boolean deleteStatefulSet(String statefulSetName) {
        try {
            V1DeleteOptions deleteOptions = new V1DeleteOptions();
            deleteOptions.setGracePeriodSeconds(Long.valueOf(0L));
            deleteOptions.setPropagationPolicy("Foreground");
            Response response = this.appsApi.deleteNamespacedStatefulSetCall(statefulSetName, this.namespace, deleteOptions, null, null, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + statefulSetName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.SEVERE, "There is no StatefulSet [" + statefulSetName + "] to delete on Kubernetes master. It may have already terminated.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when deleting the StatefulSet [" + statefulSetName + "]: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the StatefulSet: " + statefulSetName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the StatefulSet: " + statefulSetName, e);
            return false;
        }
    }

    public boolean patchStatefulSet(String ssName, int replicas) {
        String jsonPatchStr = "{\"op\":\"replace\",\"path\":\"/spec/replicas\",\"value\":" + replicas + "}";
        Object obj = new Gson().fromJson(jsonPatchStr, JsonElement.class);
        ArrayList<Object> objectList = new ArrayList<Object>();
        objectList.add(obj);
        try {
            Response response = this.appsApi.patchNamespacedStatefulSetCall(ssName, this.namespace, objectList, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + ssName + "] is patched.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when patching the StatefulSet [" + ssName + "]: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when patching the StatefulSet: " + ssName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when patching the StatefulSet: " + ssName, e);
        }
        return false;
    }

    public boolean createService(V1Service service) {
        String serviceName = service.getMetadata().getName();
        try {
            Response response = this.coreApi.createNamespacedServiceCall(this.namespace, service, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "Service [" + serviceName + "] created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the service [" + serviceName + "]: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the service: " + serviceName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the service: " + serviceName, e);
        }
        return false;
    }

    public boolean existServices(List<String> serviceNames) {
        V1ServiceList serviceList = null;
        try {
            serviceList = this.coreApi.listNamespacedService(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting service list.", e);
            throw new RuntimeException(e);
        }
        for (V1Service service : serviceList.getItems()) {
            if (!serviceNames.contains(service.getMetadata().getName())) continue;
            LOG.severe("There is already a service with the name: " + service.getMetadata().getName());
            return true;
        }
        return false;
    }

    public boolean deleteService(String serviceName) {
        V1DeleteOptions deleteOptions = new V1DeleteOptions();
        deleteOptions.setGracePeriodSeconds(Long.valueOf(0L));
        deleteOptions.setPropagationPolicy("Foreground");
        try {
            Response response = this.coreApi.deleteNamespacedServiceCall(serviceName, this.namespace, deleteOptions, null, null, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.info("Service [" + serviceName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.warning("There is no Service [" + serviceName + "] to delete on Kubernetes master. It may have already been terminated.");
                return true;
            }
            LOG.severe("Error when deleting the Service [" + serviceName + "]: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the service: " + serviceName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the service: " + serviceName, e);
            return false;
        }
    }

    public String getServiceIP(String serviceName) {
        V1ServiceList serviceList = null;
        try {
            serviceList = this.coreApi.listNamespacedService(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting service list.", e);
            throw new RuntimeException(e);
        }
        for (V1Service service : serviceList.getItems()) {
            if (!serviceName.equals(service.getMetadata().getName())) continue;
            return service.getSpec().getClusterIP();
        }
        return null;
    }

    public static boolean runProcess(String[] command) {
        StringBuilder stderr = new StringBuilder();
        int status = ProcessUtils.runSyncProcess(false, command, stderr, new File("."), false);
        return status == 0;
    }

    public boolean existPersistentVolumeClaim(String pvcName) {
        V1PersistentVolumeClaimList pvcList = null;
        try {
            pvcList = this.coreApi.listNamespacedPersistentVolumeClaim(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolumeClaim list.", e);
            throw new RuntimeException(e);
        }
        for (V1PersistentVolumeClaim pvc : pvcList.getItems()) {
            if (!pvcName.equals(pvc.getMetadata().getName())) continue;
            LOG.severe("There is already a PersistentVolumeClaim with the name: " + pvcName);
            return true;
        }
        return false;
    }

    public boolean createPersistentVolumeClaim(V1PersistentVolumeClaim pvc) {
        String pvcName = pvc.getMetadata().getName();
        try {
            Response response = this.coreApi.createNamespacedPersistentVolumeClaimCall(this.namespace, pvc, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolumeClaim [" + pvcName + "] is created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the PersistentVolumeClaim [" + pvcName + "] Response: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolumeClaim: " + pvcName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolumeClaim: " + pvcName, e);
        }
        return false;
    }

    public boolean deletePersistentVolumeClaim(String pvcName) {
        try {
            Response response = this.coreApi.deleteNamespacedPersistentVolumeClaimCall(pvcName, this.namespace, null, null, null, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolumeClaim [" + pvcName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.WARNING, "There is no PersistentVolumeClaim [" + pvcName + "] to delete on Kubernetes master. It may have already been deleted.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when deleting the PersistentVolumeClaim [" + pvcName + "] Response: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolumeClaim: " + pvcName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolumeClaim: " + pvcName, e);
            return false;
        }
    }

    public V1PersistentVolume getPersistentVolume(String pvName) {
        V1PersistentVolumeList pvList = null;
        try {
            pvList = this.coreApi.listPersistentVolume(null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolume list.", e);
            throw new RuntimeException(e);
        }
        for (V1PersistentVolume pv : pvList.getItems()) {
            if (!pvName.equals(pv.getMetadata().getName())) continue;
            return pv;
        }
        return null;
    }

    public boolean createPersistentVolume(V1PersistentVolume pv) {
        String pvName = pv.getMetadata().getName();
        try {
            Response response = this.coreApi.createPersistentVolumeCall(pv, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolume [" + pvName + "] is created.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when creating the PersistentVolume [" + pvName + "]: " + response);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolume: " + pvName, e);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolume: " + pvName, e);
        }
        return false;
    }

    public boolean deletePersistentVolume(String pvName) {
        try {
            Response response = this.coreApi.deletePersistentVolumeCall(pvName, null, null, null, null, null, null, null).execute();
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolume [" + pvName + "] is deleted.");
                return true;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.WARNING, "There is no PersistentVolume [" + pvName + "] to delete on Kubernetes master. It may have already been deleted.");
                return true;
            }
            LOG.log(Level.SEVERE, "Error when deleting the PersistentVolume [" + pvName + "]: " + response);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolume: " + pvName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolume: " + pvName, e);
            return false;
        }
    }

    public boolean existSecret(String secretName) {
        V1SecretList secretList = null;
        try {
            secretList = this.coreApi.listNamespacedSecret(this.namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting Secret list.", e);
            throw new RuntimeException(e);
        }
        for (V1Secret secret : secretList.getItems()) {
            if (!secretName.equalsIgnoreCase(secret.getMetadata().getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<JobMasterAPI.NodeInfo> getNodeInfo(String rackLabelKey, String datacenterLabelKey) {
        V1NodeList nodeList = null;
        try {
            nodeList = this.coreApi.listNode(null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting NodeList.", e);
            return null;
        }
        ArrayList<JobMasterAPI.NodeInfo> nodeInfoList = new ArrayList<JobMasterAPI.NodeInfo>();
        block2: for (V1Node node : nodeList.getItems()) {
            List addressList = node.getStatus().getAddresses();
            for (V1NodeAddress nodeAddress : addressList) {
                if (!"InternalIP".equalsIgnoreCase(nodeAddress.getType())) continue;
                String nodeIP = nodeAddress.getAddress();
                String rackName = null;
                String datacenterName = null;
                Map labelMap = node.getMetadata().getLabels();
                for (String key : labelMap.keySet()) {
                    if (key.equalsIgnoreCase(rackLabelKey)) {
                        rackName = (String)labelMap.get(key);
                    }
                    if (!key.equalsIgnoreCase(datacenterLabelKey)) continue;
                    datacenterName = (String)labelMap.get(key);
                }
                JobMasterAPI.NodeInfo nodeInfo = NodeInfoUtils.createNodeInfo((String)nodeIP, rackName, datacenterName);
                nodeInfoList.add(nodeInfo);
                continue block2;
            }
        }
        return nodeInfoList;
    }
}

