/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.bootstrap;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.rsched.bootstrap.ZKUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;

public class ZKJobMasterFinder {
    private static final Logger LOG = Logger.getLogger(ZKJobMasterFinder.class.getName());
    private Config config;
    private CuratorFramework client;
    private String jobMasterPath;
    private NodeCache jobMasterNodeCache;
    private String jobMasterIP;
    private String jobMasterPort;

    public ZKJobMasterFinder(Config config) {
        this.config = config;
        this.jobMasterPath = ZKUtil.constructJobMasterPath(config);
    }

    public void initialize() {
        this.client = ZKUtil.connectToServer(this.config);
    }

    public String getJobMasterIPandPort() {
        if (this.jobMasterIP != null) {
            return this.jobMasterIP + ":" + this.jobMasterPort;
        }
        try {
            if (this.client.checkExists().forPath(this.jobMasterPath) == null) {
                return null;
            }
            byte[] parentData = (byte[])this.client.getData().forPath(this.jobMasterPath);
            String jobMasterIPandPort = new String(parentData);
            this.setJobMasterIPandPort(jobMasterIPandPort);
            return jobMasterIPandPort;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception when trying to retrieve Job Master adress from ZK", e);
            return null;
        }
    }

    private void setJobMasterIPandPort(String jobMasterIPandPort) {
        this.jobMasterPort = jobMasterIPandPort.substring(jobMasterIPandPort.lastIndexOf(":") + 1);
        this.jobMasterIP = jobMasterIPandPort.substring(0, jobMasterIPandPort.lastIndexOf(":"));
    }

    public String waitAndGetJobMasterIPandPort(long timeLimit) {
        String jobMasterIPandPort = this.getJobMasterIPandPort();
        if (jobMasterIPandPort != null) {
            return jobMasterIPandPort;
        }
        long duration = 0L;
        while (duration < timeLimit) {
            jobMasterIPandPort = this.getJobMasterIPandPortFromCache();
            if (jobMasterIPandPort == null) {
                try {
                    Thread.sleep(50L);
                    duration += 50L;
                }
                catch (InterruptedException e) {
                    LOG.log(Level.INFO, "Thread sleep interrupted. Will try again ...", e);
                }
                continue;
            }
            return jobMasterIPandPort;
        }
        LOG.severe("Waited for Job Master to join, but timeLimit has been reached");
        return null;
    }

    private String getJobMasterIPandPortFromCache() {
        ChildData currentData;
        if (this.jobMasterIP != null) {
            return this.jobMasterIP + ":" + this.jobMasterPort;
        }
        if (this.jobMasterNodeCache == null) {
            this.jobMasterNodeCache = new NodeCache(this.client, this.jobMasterPath);
            try {
                this.jobMasterNodeCache.start();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Exception when starting jobMasterNodeCache", e);
            }
        }
        if ((currentData = this.jobMasterNodeCache.getCurrentData()) == null) {
            return null;
        }
        String jobMasterIPandPort = new String(currentData.getData());
        this.setJobMasterIPandPort(jobMasterIPandPort);
        return jobMasterIPandPort;
    }

    public void close() {
        this.client.close();
    }
}

