/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.api.util.KryoSerializer;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.ComputeResourceUtils;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public final class JobUtils {
    private static final Logger LOG = Logger.getLogger(JobUtils.class.getName());

    private JobUtils() {
    }

    public static boolean writeJobFile(JobAPI.Job job, String fileName) {
        byte[] jobBytes = job.toByteArray();
        return FileUtils.writeToFile(fileName, jobBytes, true);
    }

    public static JobAPI.Job readJobFile(Config cfg, String fileName) {
        try {
            byte[] fileBytes = FileUtils.readFromFile(fileName);
            JobAPI.Job.Builder builder = JobAPI.Job.newBuilder();
            return ((JobAPI.Job.Builder)builder.mergeFrom(fileBytes)).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failed to read the job file: " + fileName);
        }
    }

    public static Map<String, Object> readCommandLineOpts() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String commandOptions = System.getenv("TWISTER2_OPTIONS");
        if (commandOptions != null) {
            String[] configs;
            for (String config : configs = commandOptions.split(",")) {
                String[] options = config.split(":");
                if (options.length != 2) continue;
                ret.put(options[0], options[1]);
            }
        }
        return ret;
    }

    public static String jobClassPath(Config cfg, JobAPI.Job job, String wd) {
        StringBuilder classPathBuilder = new StringBuilder();
        classPathBuilder.append(Paths.get(wd, job.getJobName(), job.getJobFormat().getJobFile()).toString());
        return classPathBuilder.toString();
    }

    public static String systemClassPath(Config cfg) {
        String libDirectory = SchedulerContext.libDirectory((Config)cfg);
        String libFile = Paths.get(libDirectory, new String[0]).toString();
        String classPath = "";
        File folder = new File(libFile);
        String libName = folder.getName();
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                classPath = !"".equals(classPath) ? classPath + ":" + Paths.get(libDirectory, listOfFiles[i].getName()).toString() : classPath + Paths.get(libDirectory, listOfFiles[i].getName()).toString();
            }
        }
        return classPath;
    }

    public static Config overrideConfigs(JobAPI.Job job, Config config) {
        Config.Builder builder = Config.newBuilder().putAll(config);
        JobAPI.Config conf = job.getConfig();
        Map configMapSerialized = conf.getConfigByteMapMap();
        for (Map.Entry e : configMapSerialized.entrySet()) {
            String key = (String)e.getKey();
            byte[] bytes = ((ByteString)e.getValue()).toByteArray();
            Object object = new KryoSerializer().deserialize(bytes);
            builder.put(key, object);
        }
        return builder.build();
    }

    public static String getJobDescriptionFilePath(String workingDirectory, String jobFileName, Config config) {
        return Paths.get(workingDirectory, jobFileName + ".job").toAbsolutePath().toString();
    }

    public static String getJobDescriptionFilePath(String jobFileName, Config config) {
        String home = Context.twister2Home((Config)config);
        return Paths.get(home, jobFileName + ".job").toAbsolutePath().toString();
    }

    public static Config resolveJobId(Config config, String jobName) {
        Config.Builder builder = Config.newBuilder().putAll(config);
        String jobId = config.getStringValue("twister2.job.id");
        if (jobId == null) {
            jobId = String.format("%s-%s", jobName, UUID.randomUUID().toString());
            builder.put("twister2.job.id", (Object)jobId);
        }
        LOG.severe("Job ID assigned : " + jobId);
        return builder.build();
    }

    public static Config updateConfigs(JobAPI.Job job, Config config) {
        Config.Builder builder = Config.newBuilder().putAll(config);
        builder.put("twister2.job.name", (Object)job.getJobName());
        builder.put("twister2.job.worker.class", (Object)job.getWorkerClassName());
        builder.put("twister2.worker.instances", (Object)job.getNumberOfWorkers());
        return builder.build();
    }

    public static JobAPI.ComputeResource getComputeResource(JobAPI.Job job, int index) {
        for (JobAPI.ComputeResource computeResource : job.getComputeResourceList()) {
            if (computeResource.getIndex() != index) continue;
            return computeResource;
        }
        return null;
    }

    public static String toString(JobAPI.Job job) {
        String jobStr = "[jobName=" + job.getJobName() + "], [numberOfWorkers=" + job.getNumberOfWorkers() + "]\n[workerClass=" + job.getWorkerClassName() + "]";
        for (JobAPI.ComputeResource cr : job.getComputeResourceList()) {
            jobStr = jobStr + "\n" + ComputeResourceUtils.toString((JobAPI.ComputeResource)cr);
        }
        return jobStr;
    }
}

