/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPICommand;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIContext;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StandaloneCommand
extends MPICommand {
    private static final Logger LOG = Logger.getLogger(StandaloneCommand.class.getName());

    public StandaloneCommand(Config cfg, String workingDirectory) {
        super(cfg, workingDirectory);
    }

    @Override
    protected String[] killCommand() {
        return new String[0];
    }

    @Override
    protected List<String> mpiCommand(String workingDirectory, JobAPI.Job job) {
        String twister2Home = Paths.get(workingDirectory, job.getJobName()).toString();
        String configDirectoryName = Paths.get(workingDirectory, job.getJobName(), SchedulerContext.clusterType((Config)this.config)).toString();
        String nodesFileName = MPIContext.nodeFiles(this.config);
        List<String> mpiCommand = this.mpiCommand(this.getScriptPath());
        Map<String, Object> map = this.mpiCommandArguments(this.config, job);
        mpiCommand.add(map.get("procs").toString());
        mpiCommand.add(map.get("java_props").toString());
        mpiCommand.add(map.get("classpath").toString());
        mpiCommand.add(map.get("container_class").toString());
        mpiCommand.add(job.getJobName());
        mpiCommand.add(twister2Home);
        mpiCommand.add(twister2Home);
        mpiCommand.add(Paths.get(configDirectoryName, nodesFileName).toString());
        mpiCommand.add(MPIContext.mpiRunFile(this.config));
        mpiCommand.add("-Xmx" + this.getMemory(job) + "m");
        mpiCommand.add("-Xms" + this.getMemory(job) + "m");
        mpiCommand.add(this.config.getIntegerValue("__job_master_port__", 0) + "");
        mpiCommand.add(this.config.getStringValue("__job_master_ip__", "ip"));
        int cpusPerProc = 1;
        if (job.getComputeResourceCount() > 0) {
            double cpu = job.getComputeResource(0).getCpu();
            cpusPerProc = (int)Math.ceil(cpu);
        }
        mpiCommand.add(MPIContext.mpiMapBy(this.config, cpusPerProc));
        if (this.config.getBooleanValue("debug", false).booleanValue()) {
            mpiCommand.add("debug");
        } else {
            mpiCommand.add("no-debug");
        }
        if (StandaloneCommand.getJavaVersion() >= 9) {
            mpiCommand.add("suppress_illegal_access_warn");
        } else {
            mpiCommand.add("allow_illegal_access_warn");
        }
        return mpiCommand;
    }

    private List<String> mpiCommand(String mpiScript) {
        ArrayList<String> slurmCmd = new ArrayList<String>(Collections.singletonList(mpiScript));
        return slurmCmd;
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        LOG.info("Java version : " + version);
        return Integer.parseInt(version);
    }
}

