/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.scheduler.ILauncher;
import edu.iu.dsc.tws.common.driver.IScalerPerCluster;
import edu.iu.dsc.tws.common.driver.NullScalar;
import edu.iu.dsc.tws.common.util.NetworkUtils;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.NodeInfoUtils;
import edu.iu.dsc.tws.rsched.core.ResourceRuntime;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadTerminator;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIContext;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPIController;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import edu.iu.dsc.tws.rsched.utils.ResourceSchedulerUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class MPILauncher
implements ILauncher {
    private static final Logger LOG = Logger.getLogger(MPILauncher.class.getName());
    private Config config;
    private String jobWorkingDirectory;

    public void initialize(Config mConfig) {
        this.config = mConfig;
        this.jobWorkingDirectory = MPIContext.workingDirectory(mConfig);
    }

    public void close() {
    }

    public boolean terminateJob(String jobName) {
        return false;
    }

    private void distributeJobFiles(JobAPI.Job job) throws IOException {
        File localSourceRoot = new File(this.config.getStringValue("temporary.packages.path"));
        File jobFile = new File(localSourceRoot, "twister2-job.tar.gz");
        WildcardFileFilter fileFilter = new WildcardFileFilter("twister2-core-*.*.*.tar.gz");
        File[] files = localSourceRoot.listFiles((FileFilter)fileFilter);
        if (files == null || files.length == 0) {
            throw new RuntimeException("Couldn't find twister2 core at " + localSourceRoot.getAbsolutePath());
        }
        File coreFile = files[0];
        String jobFileMD5 = FileUtils.md5(jobFile);
        String coreFileMD5 = FileUtils.md5(coreFile);
        LOG.info(String.format("Found Job file : %s", jobFile.getAbsolutePath()));
        LOG.info(String.format("Found Core file : %s", coreFile.getAbsolutePath()));
        Path tempHotsFile = Files.createTempFile("hosts-" + job.getJobName(), "", new FileAttribute[0]);
        int np = this.createOneSlotPerNodeFile(tempHotsFile);
        StringBuilder stringBuilder = new StringBuilder();
        int status = ProcessUtils.runSyncProcess(false, new String[]{"conf/standalone/bootstrap.sh", Integer.toString(np), tempHotsFile.toAbsolutePath().toString(), job.getJobName(), this.jobWorkingDirectory, jobFile.getAbsolutePath(), jobFileMD5, coreFile.getAbsolutePath(), coreFileMD5}, stringBuilder, new File("."), true);
        if (status != 0) {
            LOG.severe("Failed to execute bootstrap procedure : " + status);
            throw new RuntimeException("Bootstrap procedure failed with status " + status);
        }
        if (stringBuilder.length() != 0) {
            LOG.severe("Bootstrap procedure failed with error : " + stringBuilder.toString());
            throw new RuntimeException("Bootstrap procedure failed with error " + stringBuilder.toString());
        }
        LOG.info("Bootstrap procedure executed successfully.");
    }

    private int createOneSlotPerNodeFile(Path tempHostFile) throws IOException {
        List<String> hosts = Files.readAllLines(new File("./conf/standalone/nodes").toPath());
        StringBuilder hostFileBuilder = new StringBuilder();
        int ipCount = 0;
        for (String host : hosts) {
            String[] parts = host.split(" ");
            if (parts.length <= 0 || parts[0].trim().isEmpty()) continue;
            ++ipCount;
            hostFileBuilder.append(parts[0]).append(" ").append("slots=1").append(System.getProperty("line.separator"));
        }
        Files.write(tempHostFile, hostFileBuilder.toString().getBytes(), new OpenOption[0]);
        return ipCount;
    }

    public boolean launch(JobAPI.Job job) {
        LOG.log(Level.INFO, "Launching job for cluster {0}", MPIContext.clusterType((Config)this.config));
        if (!MPIContext.isSharedFs(this.config)) {
            LOG.info("Configured as NON SHARED file system. Running bootstrap procedure to distribute files...");
            try {
                this.distributeJobFiles(job);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error in distributing job files", e);
                throw new RuntimeException("Error in distributing job files");
            }
        } else {
            LOG.info("Configured as SHARED file system. Skipping bootstrap procedure & setting up working directory");
            if (!this.setupWorkingDirectory(job.getJobName())) {
                throw new RuntimeException("Failed to setup the directory");
            }
        }
        this.config = Config.newBuilder().putAll(this.config).put("twister2.working_directory", (Object)this.jobWorkingDirectory).build();
        JobMaster jobMaster = null;
        Thread jmThread = null;
        if (JobMasterContext.isJobMasterUsed((Config)this.config) && JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
            try {
                int port = NetworkUtils.getFreePort();
                String hostAddress = JobMasterContext.jobMasterIP((Config)this.config);
                if (hostAddress == null) {
                    hostAddress = InetAddress.getLocalHost().getHostAddress();
                }
                this.config = Config.newBuilder().putAll(this.config).put("__job_master_port__", (Object)port).put("__job_master_ip__", (Object)hostAddress).build();
                LOG.log(Level.INFO, String.format("Starting the job master: %s:%d", hostAddress, port));
                JobMasterAPI.NodeInfo jobMasterNodeInfo = NodeInfoUtils.createNodeInfo((String)hostAddress, (String)"default", (String)"default");
                NullScalar nullScaler = new NullScalar();
                jobMaster = new JobMaster(this.config, hostAddress, port, (IJobTerminator)new NomadTerminator(), job, jobMasterNodeInfo, (IScalerPerCluster)nullScaler);
                jobMaster.addShutdownHook(true);
                jmThread = jobMaster.startJobMasterThreaded();
                ResourceRuntime.getInstance().setJobMasterHostPort(hostAddress, port);
            }
            catch (UnknownHostException e) {
                LOG.log(Level.SEVERE, "Exception when getting local host address: ", e);
                throw new RuntimeException(e);
            }
        }
        boolean[] start = new boolean[]{false};
        Thread controllerThread = new Thread(() -> {
            MPIController controller = new MPIController(true);
            controller.initialize(this.config);
            start[0] = controller.start(job);
        });
        controllerThread.start();
        try {
            controllerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (jmThread != null && JobMasterContext.isJobMasterUsed((Config)this.config) && JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
            try {
                jmThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return start[0];
    }

    protected boolean setupWorkingDirectory(String jobName) {
        String corePackage = MPIContext.corePackageFileName((Config)this.config);
        String jobPackageURI = MPIContext.jobPackageUri((Config)this.config).toString();
        return ResourceSchedulerUtils.setupWorkingDirectory(jobName, this.jobWorkingDirectory, corePackage, jobPackageURI, Context.verbose((Config)this.config));
    }
}

