/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos.mpi;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerController;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.net.Inet4Address;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class MesosMPISlaveStarter {
    public static final Logger LOG = Logger.getLogger(MesosMPISlaveStarter.class.getName());
    private static Config config;
    private static String jobName;
    private static int workerID;
    private static int resourceIndex;
    private static int startingPort;

    private MesosMPISlaveStarter() {
    }

    public static void main(String[] args) throws Exception {
        workerID = Integer.parseInt(System.getenv("WORKER_ID"));
        jobName = System.getenv("JOB_NAME");
        String twister2Home = Paths.get("", new String[0]).toAbsolutePath().toString();
        String configDir = "twister2-job";
        config = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)"mesos");
        resourceIndex = Integer.parseInt(System.getenv("COMPUTE_RESOURCE_INDEX"));
        Map<String, Integer> additionalPorts = MesosWorkerUtils.generateAdditionalPorts(config, startingPort);
        List<Object> workerNetworkInfoList = new ArrayList();
        try {
            JobAPI.Job job = JobUtils.readJobFile(null, "twister2-job/" + jobName + ".job");
            JobAPI.ComputeResource computeResource = JobUtils.getComputeResource(job, resourceIndex);
            MesosWorkerController workerController = new MesosWorkerController(config, job, Inet4Address.getLocalHost().getHostAddress(), 2023, workerID, computeResource, additionalPorts);
            LOG.info("Initializing with zookeeper ");
            workerController.initializeWithZooKeeper();
            LOG.info("Waiting for all workers to join");
            workerNetworkInfoList = workerController.getAllWorkers();
            LOG.info("Everyone has joined");
            Thread.sleep(30000L);
            workerController.close();
        }
        catch (Exception e) {
            LOG.severe("Host unknown " + e.getMessage());
        }
        Thread.sleep(3000000L);
    }

    static {
        resourceIndex = 0;
        startingPort = 30000;
    }
}

