/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos.mpi;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.master.worker.JMWorkerAgent;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.bootstrap.ZKJobMasterFinder;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerController;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerLogger;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosWorkerUtils;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class MesosMPIMasterStarter {
    public static final Logger LOG = Logger.getLogger(MesosMPIMasterStarter.class.getName());
    private Config config;
    private String jobName;
    private JMWorkerAgent jobMasterAgent;
    private static int startingPort = 30000;
    private static int resourceIndex = 0;

    private MesosMPIMasterStarter() {
    }

    public static void main(String[] args) throws Exception {
        MesosMPIMasterStarter mpiMaster = new MesosMPIMasterStarter();
        String homeDir = System.getenv("HOME");
        int workerId = Integer.parseInt(System.getenv("WORKER_ID"));
        mpiMaster.jobName = System.getenv("JOB_NAME");
        resourceIndex = Integer.parseInt(System.getenv("COMPUTE_RESOURCE_INDEX"));
        String twister2Home = Paths.get("", new String[0]).toAbsolutePath().toString();
        String configDir = "twister2-job";
        mpiMaster.config = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)"mesos");
        MesosWorkerLogger logger = new MesosWorkerLogger(mpiMaster.config, "/persistent-volume/logs", "mpiMaster");
        logger.initLogging();
        Map<String, Integer> additionalPorts = MesosWorkerUtils.generateAdditionalPorts(mpiMaster.config, startingPort);
        MesosWorkerController workerController = null;
        List<Object> workerInfoList = new ArrayList();
        int numberOfWorkers = 0;
        try {
            JobAPI.Job job = JobUtils.readJobFile(null, "twister2-job/" + mpiMaster.jobName + ".job");
            JobAPI.ComputeResource computeResource = JobUtils.getComputeResource(job, resourceIndex);
            workerController = new MesosWorkerController(mpiMaster.config, job, Inet4Address.getLocalHost().getHostAddress(), 2023, workerId, computeResource, additionalPorts);
            LOG.info("Initializing with zookeeper");
            workerController.initializeWithZooKeeper();
            LOG.info("Waiting for all workers to join");
            workerInfoList = workerController.getAllWorkers();
            LOG.info("Everyone has joined");
        }
        catch (Exception e) {
            LOG.severe("Host unkown " + e.getMessage());
        }
        ZKJobMasterFinder finder = new ZKJobMasterFinder(mpiMaster.config);
        finder.initialize();
        String jobMasterIPandPort = finder.getJobMasterIPandPort();
        if (jobMasterIPandPort == null) {
            LOG.info("Job Master has not joined yet. Will wait and try to get the address ...");
            jobMasterIPandPort = finder.waitAndGetJobMasterIPandPort(20000L);
            LOG.info("Job Master address: " + jobMasterIPandPort);
        } else {
            LOG.info("Job Master address: " + jobMasterIPandPort);
        }
        finder.close();
        String jobMasterPortStr = jobMasterIPandPort.substring(jobMasterIPandPort.lastIndexOf(":") + 1);
        int jobMasterPort = Integer.parseInt(jobMasterPortStr);
        String jobMasterIP = jobMasterIPandPort.substring(0, jobMasterIPandPort.lastIndexOf(":"));
        LOG.info("JobMaster IP..: " + jobMasterIP);
        LOG.info("Worker ID..: " + workerId);
        StringBuilder outputBuilder = new StringBuilder();
        int workerCount = workerController.getNumberOfWorkers();
        LOG.info("Worker Count..: " + workerCount);
        mpiMaster.startJobMasterAgent(workerController.getWorkerInfo(), jobMasterIP, jobMasterPort, numberOfWorkers);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("/twister2/hostFile", true)));
        for (int i = 0; i < workerCount; ++i) {
            writer.write(((JobMasterAPI.WorkerInfo)workerInfoList.get(i)).getWorkerIP() + "\n");
            LOG.info("Host IP..: " + ((JobMasterAPI.WorkerInfo)workerInfoList.get(i)).getWorkerIP());
        }
        ((Writer)writer).close();
        String mpiClassNameToRun = "edu.iu.dsc.tws.rsched.schedulers.mesos.mpi.MesosMPIWorkerStarter";
        LOG.info("Before mpirun");
        CharSequence[] command = new String[]{"mpirun", "-allow-run-as-root", "-npernode", "1", "--mca", "btl_tcp_if_include", "eth0", "--hostfile", "/twister2/hostFile", "java", "-cp", "twister2-job/libexamples-java.jar:twister2-core/lib/*", mpiClassNameToRun, mpiMaster.jobName, jobMasterIP};
        LOG.info("command:" + String.join((CharSequence)" ", command));
        ProcessUtils.runSyncProcess(false, (String[])command, outputBuilder, new File("."), true);
        mpiMaster.jobMasterAgent.sendWorkerCompletedMessage();
        mpiMaster.jobMasterAgent.close();
        workerController.close();
        LOG.info("Job DONE");
    }

    public void startJobMasterAgent(JobMasterAPI.WorkerInfo workerInfo, String jobMasterIP, int jobMasterPort, int numberOfWorkers) {
        LOG.info("JobMaster IP..: " + jobMasterIP);
        LOG.info("NETWORK INFO..: " + workerInfo.getWorkerIP());
        this.jobMasterAgent = JMWorkerAgent.createJMWorkerAgent((Config)this.config, (JobMasterAPI.WorkerInfo)workerInfo, (String)jobMasterIP, (int)jobMasterPort, (int)numberOfWorkers);
        this.jobMasterAgent.startThreaded(false);
    }
}

