/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.ILauncher;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosContext;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosController;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosScheduler;
import java.util.logging.Logger;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;

public class MesosLauncher
implements ILauncher {
    private MesosController controller;
    private MesosSchedulerDriver driver;
    private static final Logger LOG = Logger.getLogger(MesosLauncher.class.getName());
    private Config config;

    public void initialize(Config mconfig) {
        this.config = mconfig;
        this.controller = new MesosController(this.config);
    }

    public void close() {
    }

    public boolean terminateJob(String jobName) {
        boolean status;
        if (this.driver == null) {
            status = true;
            LOG.warning("Job already terminated!");
        } else {
            status = this.driver.stop() != Protos.Status.DRIVER_STOPPED;
        }
        return status;
    }

    public boolean launch(JobAPI.Job job) {
        this.runFramework(MesosContext.getMesosMasterUri(this.config), job);
        return false;
    }

    private void runFramework(String mesosMaster, JobAPI.Job job) {
        MesosScheduler scheduler = new MesosScheduler(this.controller, this.config, job);
        this.driver = new MesosSchedulerDriver((Scheduler)scheduler, this.controller.getFrameworkInfo(), mesosMaster);
        boolean status = this.driver.run() != Protos.Status.DRIVER_STOPPED;
        LOG.warning("Job already terminated!");
    }
}

