/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.mesos;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.SchedulerContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.mesos.MesosContext;
import java.util.logging.Logger;
import org.apache.mesos.Protos;
import org.apache.mesos.SchedulerDriver;

public class MesosController {
    public static final Logger LOG = Logger.getLogger(MesosController.class.getName());
    public static SchedulerDriver schedulerDriver;
    private Config config;
    private String workerClass;

    public MesosController(Config mconfig) {
        this.config = mconfig;
        this.workerClass = MesosContext.mesosWorkerClass(this.config);
    }

    public void setSchedulerDriver(SchedulerDriver driver) {
        schedulerDriver = driver;
    }

    public Protos.FrameworkInfo getFrameworkInfo() {
        String frameworkName = MesosContext.MesosFrameworkName(this.config);
        Protos.FrameworkInfo.Builder builder = Protos.FrameworkInfo.newBuilder();
        builder.setFailoverTimeout(120000.0);
        builder.setUser("");
        builder.setName(frameworkName);
        return builder.build();
    }

    private Protos.CommandInfo.URI getJobUri() {
        Protos.CommandInfo.URI.Builder uriBuilder = Protos.CommandInfo.URI.newBuilder();
        uriBuilder.setValue(MesosContext.getHttpFetchURI(this.config) + "/" + SchedulerContext.jobPackageFileName((Config)this.config));
        uriBuilder.setExtract(true);
        return uriBuilder.build();
    }

    private Protos.CommandInfo.URI getCoreUri() {
        Protos.CommandInfo.URI.Builder uriBuilder = Protos.CommandInfo.URI.newBuilder();
        uriBuilder.setValue(MesosContext.getHttpFetchURI(this.config) + "/" + SchedulerContext.corePackageFileName((Config)this.config));
        uriBuilder.setExtract(true);
        return uriBuilder.build();
    }

    public Protos.CommandInfo getCommandInfo(String jobName, String workerName) {
        String command = "java -cp \"twister2-core/lib/*:twister2-job/libexamples-java.jar:/root/.twister2/repository/twister2-core/lib/mesos-1.5.0.jar\" " + this.workerClass + " " + jobName + " " + workerName;
        Protos.CommandInfo.Builder cmdInfoBuilder = Protos.CommandInfo.newBuilder();
        cmdInfoBuilder.addUris(this.getJobUri());
        cmdInfoBuilder.addUris(this.getCoreUri());
        cmdInfoBuilder.setValue(command);
        return cmdInfoBuilder.build();
    }

    public Protos.ExecutorInfo getExecutorInfo(String jobName, String executorName) {
        Protos.ExecutorInfo.Builder builder = Protos.ExecutorInfo.newBuilder();
        builder.setExecutorId(Protos.ExecutorID.newBuilder().setValue(executorName));
        builder.setCommand(this.getCommandInfo(jobName, executorName));
        builder.setName(executorName);
        return builder.build();
    }

    public boolean isResourceSatisfy(Protos.Offer offer, JobAPI.ComputeResource compResource) {
        double cpu = 0.0;
        double mem = 0.0;
        double disk = 0.0;
        for (Protos.Resource r : offer.getResourcesList()) {
            if (r.getName().equals("cpus")) {
                cpu = r.getScalar().getValue();
            }
            if (r.getName().equals("mem")) {
                mem = r.getScalar().getValue();
            }
            if (!r.getName().equals("disk")) continue;
            disk = r.getScalar().getValue();
        }
        if (cpu < compResource.getCpu() * (double)MesosContext.containerPerWorker(this.config)) {
            LOG.info("CPU request can not be granted");
            return false;
        }
        if (mem < (double)(compResource.getRamMegaBytes() * MesosContext.containerPerWorker(this.config))) {
            LOG.info("Memory request can not be granted");
            return false;
        }
        if (disk < compResource.getDiskGigaBytes() * 1000.0 * (double)MesosContext.containerPerWorker(this.config)) {
            LOG.info("disk request can not be granted");
            return false;
        }
        return true;
    }

    public String createPersistentJobDirName(String jobName) {
        return SchedulerContext.nfsServerPath((Config)this.config) + "/" + jobName;
    }

    public boolean patchWorkers(String ssName, int replicas) {
        return false;
    }
}

