/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.proto.system.job.JobAPI;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class KubernetesUtils {
    private static final Logger LOG = Logger.getLogger(KubernetesUtils.class.getName());
    private static final int MAX_JOB_NAME_LENGTH = 45;

    private KubernetesUtils() {
    }

    public static int indexFromName(String name) {
        return Integer.parseInt(name.substring(name.lastIndexOf("-") + 1));
    }

    public static String removeIndexFromName(String name) {
        return name.substring(0, name.lastIndexOf("-"));
    }

    public static String[] createCopyCommand(String filename, String namespace, String podName) {
        String targetDir = String.format("%s/%s:%s", namespace, podName, "/twister2-memory-dir");
        return new String[]{"kubectl", "cp", filename, targetDir};
    }

    public static String podNameFromStatefulSetName(String ssName, int podIndex) {
        return ssName + "-" + podIndex;
    }

    public static String createServiceName(String jobName) {
        return "t2-srv-" + jobName;
    }

    public static String createJobMasterServiceName(String jobName) {
        return "t2-srv-" + jobName + "-jm";
    }

    public static String createPersistentVolumeClaimName(String jobName) {
        return "twister2-storage-" + jobName;
    }

    public static String createPersistentVolumeName(String jobName) {
        return "persistent-volume-" + jobName;
    }

    public static String createServiceLabel(String jobName) {
        return "t2-srv-lb-" + jobName;
    }

    public static String createJobMasterServiceLabel(String jobName) {
        return "t2-srv-lb-" + jobName + "-jm";
    }

    public static String createJobMasterRoleLabel(String jobName) {
        return jobName + "-jm";
    }

    public static String createWorkerRoleLabel(String jobName) {
        return jobName + "-worker";
    }

    public static String createJobPodsLabel(String jobName) {
        return "twister2-" + jobName;
    }

    public static String createServiceLabelWithKey(String jobName) {
        return "app=" + KubernetesUtils.createServiceLabel(jobName);
    }

    public static String createJobMasterServiceLabelWithKey(String jobName) {
        return "app=" + KubernetesUtils.createJobMasterServiceLabel(jobName);
    }

    public static String createJobPodsLabelWithKey(String jobName) {
        return "twister2-job-pods=" + KubernetesUtils.createJobPodsLabel(jobName);
    }

    public static String createJobMasterRoleLabelWithKey(String jobName) {
        return "twister2-role=" + KubernetesUtils.createJobMasterRoleLabel(jobName);
    }

    public static String createWorkerRoleLabelWithKey(String jobName) {
        return "twister2-role=" + KubernetesUtils.createWorkerRoleLabel(jobName);
    }

    public static String createContainerName(int containerIndex) {
        return "twister2-container-" + containerIndex;
    }

    public static String createWorkersStatefulSetName(String jobName, int index) {
        return jobName + "-" + index;
    }

    public static String createJobMasterStatefulSetName(String jobName) {
        return jobName + "-jm";
    }

    public static String createJobMasterPodName(String jobName) {
        return KubernetesUtils.createJobMasterStatefulSetName(jobName) + "-0";
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Exception when getting local host address: ", e);
            return null;
        }
    }

    public static InetAddress convertToIPAddress(String ipStr) {
        try {
            return InetAddress.getByName(ipStr);
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Exception when converting to IP adress: ", e);
            return null;
        }
    }

    public static boolean jobNameConformsToK8sNamingRules(String jobName) {
        if (jobName.length() > 45) {
            LOG.warning("jobName is longer than 45 chars: " + jobName);
            return false;
        }
        return jobName.matches("[a-z]([-a-z0-9]*[a-z0-9])?");
    }

    public static String convertJobNameToK8sFormat(String jobName) {
        String modifiedJobName = jobName.replace("_", "-");
        modifiedJobName = modifiedJobName.replace(".", "-");
        modifiedJobName = modifiedJobName.toLowerCase(Locale.ENGLISH);
        if ((modifiedJobName = modifiedJobName.replaceAll("[^a-z0-9\\-]", "")).matches("[^a-z][-a-z0-9]*")) {
            modifiedJobName = "a" + modifiedJobName.substring(1);
        }
        if (modifiedJobName.matches("[-a-z0-9]*[-]")) {
            modifiedJobName = modifiedJobName.substring(0, modifiedJobName.length() - 1) + "z";
        }
        if (modifiedJobName.length() > 45) {
            modifiedJobName = modifiedJobName.substring(0, 45);
        }
        return modifiedJobName;
    }

    public static int numberOfWorkerPods(JobAPI.Job job) {
        int podsCount = 0;
        for (JobAPI.ComputeResource computeResource : job.getComputeResourceList()) {
            podsCount += computeResource.getInstances();
        }
        return podsCount;
    }

    public static ArrayList<String> generatePodNames(JobAPI.Job job) {
        ArrayList<String> podNames = new ArrayList<String>();
        List resourceList = job.getComputeResourceList();
        for (int i = 0; i < resourceList.size(); ++i) {
            JobAPI.ComputeResource computeResource = (JobAPI.ComputeResource)resourceList.get(i);
            int podsCount = computeResource.getInstances();
            int index = computeResource.getIndex();
            for (int j = 0; j < podsCount; ++j) {
                String ssName = KubernetesUtils.createWorkersStatefulSetName(job.getJobName(), index);
                String podName = KubernetesUtils.podNameFromStatefulSetName(ssName, j);
                podNames.add(podName);
            }
        }
        return podNames;
    }
}

