/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.bootstrap;

import com.google.common.primitives.Ints;
import com.google.protobuf.InvalidProtocolBufferException;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.rsched.bootstrap.ZKContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;

public final class ZKUtil {
    public static final Logger LOG = Logger.getLogger(ZKUtil.class.getName());

    private ZKUtil() {
    }

    public static CuratorFramework connectToServer(Config config) {
        String zkServer = ZKContext.zooKeeperServerAddresses(config);
        try {
            CuratorFramework client = CuratorFrameworkFactory.newClient((String)zkServer, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
            client.start();
            LOG.log(Level.INFO, "Connected to ZooKeeper server: " + zkServer);
            return client;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not connect to ZooKeeper server" + zkServer, e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isThereAnActiveJob(String jobName, Config config) {
        try {
            CuratorFramework client = ZKUtil.connectToServer(config);
            String jobPath = ZKUtil.constructJobPath(config, jobName);
            if (client.checkExists().forPath(jobPath) == null) {
                return false;
            }
            if (((List)client.getChildren().forPath(jobPath)).size() == 0) {
                ZKUtil.deleteJobZNodes(config, client, jobName);
                client.close();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            return false;
        }
    }

    public static String constructJobPath(Config config, String jobName) {
        return ZKContext.rootNode(config) + "/" + jobName;
    }

    public static String constructDaiPathForWorkerID(Config config, String jobName) {
        return ZKContext.rootNode(config) + "/" + jobName + "-dai-for-worker-id";
    }

    public static String constructDaiPathForBarrier(Config config, String jobName) {
        return ZKContext.rootNode(config) + "/" + jobName + "-dai-for-barrier";
    }

    public static String constructBarrierPath(Config config, String jobName) {
        return ZKContext.rootNode(config) + "/" + jobName + "-barrier";
    }

    public static String constructJobLockPath(Config config, String jobName) {
        return ZKContext.rootNode(config) + "/" + jobName + "-lock";
    }

    public static String constructWorkerPath(String jobPath, String workerHostAndPort) {
        return jobPath + "/" + workerHostAndPort;
    }

    public static String constructJobMasterPath(Config config) {
        return ZKContext.rootNode(config) + "/" + Context.jobName((Config)config) + "-job-master";
    }

    public static boolean deleteJobZNodes(Config config, CuratorFramework client, String jobName) {
        try {
            String jobPath = ZKUtil.constructJobPath(config, jobName);
            if (client.checkExists().forPath(jobPath) != null) {
                client.delete().deletingChildrenIfNeeded().forPath(jobPath);
                LOG.log(Level.INFO, "Job Znode deleted from ZooKeeper: " + jobPath);
            } else {
                LOG.log(Level.INFO, "No job znode exists in ZooKeeper to delete for: " + jobPath);
            }
            String daiPath = ZKUtil.constructDaiPathForWorkerID(config, jobName);
            if (client.checkExists().forPath(daiPath) != null) {
                ((ChildrenDeletable)client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(daiPath);
                LOG.info("DistributedAtomicInteger for workerID deleted from ZooKeeper: " + daiPath);
            } else {
                LOG.info("DistributedAtomicInteger for workerID not deleted from ZooKeeper: " + daiPath);
            }
            daiPath = ZKUtil.constructDaiPathForBarrier(config, jobName);
            if (client.checkExists().forPath(daiPath) != null) {
                ((ChildrenDeletable)client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(daiPath);
                LOG.info("DistributedAtomicInteger for barrier deleted from ZooKeeper: " + daiPath);
            } else {
                LOG.info("DistributedAtomicInteger for workerID not deleted from ZooKeeper: " + daiPath);
            }
            String lockPath = ZKUtil.constructJobLockPath(config, jobName);
            if (client.checkExists().forPath(lockPath) != null) {
                ((ChildrenDeletable)client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(lockPath);
                LOG.log(Level.INFO, "Distributed lock znode deleted from ZooKeeper: " + lockPath);
            } else {
                LOG.log(Level.INFO, "No distributed lock znode to delete from ZooKeeper: " + lockPath);
            }
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            return false;
        }
    }

    public static boolean terminateJob(String jobName, Config config) {
        try {
            CuratorFramework client = ZKUtil.connectToServer(config);
            boolean deleteResult = ZKUtil.deleteJobZNodes(config, client, jobName);
            client.close();
            return deleteResult;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not delete job znodes", e);
            return false;
        }
    }

    public static PersistentNode createPersistentEphemeralZnode(CuratorFramework client, String path, byte[] payload) {
        return new PersistentNode(client, CreateMode.EPHEMERAL, true, path, payload);
    }

    public static PersistentNode createPersistentZnode(CuratorFramework client, String path, byte[] payload) {
        return new PersistentNode(client, CreateMode.EPHEMERAL, false, path, payload);
    }

    public static List<JobMasterAPI.WorkerInfo> decodeWorkerInfos(byte[] encodedBytes) {
        int length;
        if (encodedBytes == null) {
            return null;
        }
        ArrayList<JobMasterAPI.WorkerInfo> workerInfoList = new ArrayList<JobMasterAPI.WorkerInfo>();
        for (int nextWorkerInfoIndex = 0; nextWorkerInfoIndex < encodedBytes.length; nextWorkerInfoIndex += 4 + length) {
            length = ZKUtil.intFromBytes(encodedBytes, nextWorkerInfoIndex);
            try {
                JobMasterAPI.WorkerInfo workerInfo = ((JobMasterAPI.WorkerInfo.Builder)JobMasterAPI.WorkerInfo.newBuilder().mergeFrom(encodedBytes, nextWorkerInfoIndex + 4, length)).build();
                workerInfoList.add(workerInfo);
                continue;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.log(Level.SEVERE, "Could not decode received byte array as a WorkerInfo object", e);
                return null;
            }
        }
        return workerInfoList;
    }

    public static byte[] encodeWorkerInfo(JobMasterAPI.WorkerInfo workerInfo) {
        byte[] workerInfoBytes = workerInfo.toByteArray();
        byte[] lengthBytes = Ints.toByteArray((int)workerInfoBytes.length);
        return ZKUtil.addTwoByteArrays(lengthBytes, workerInfoBytes);
    }

    public static byte[] addTwoByteArrays(byte[] byteArray1, byte[] byteArray2) {
        byte[] allBytes = new byte[byteArray1.length + byteArray2.length];
        System.arraycopy(byteArray1, 0, allBytes, 0, byteArray1.length);
        System.arraycopy(byteArray2, 0, allBytes, byteArray1.length, byteArray2.length);
        return allBytes;
    }

    public static int intFromBytes(byte[] byteArray, int startIndex) {
        return Ints.fromBytes((byte)byteArray[startIndex], (byte)byteArray[startIndex + 1], (byte)byteArray[startIndex + 2], (byte)byteArray[startIndex + 3]);
    }
}

