/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.worker;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.net.request.MessageHandler;
import edu.iu.dsc.tws.api.net.request.RequestID;
import edu.iu.dsc.tws.api.resource.IReceiverFromDriver;
import edu.iu.dsc.tws.api.resource.ISenderToDriver;
import edu.iu.dsc.tws.common.net.tcp.request.RRClient;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMDriverAgent
implements ISenderToDriver,
MessageHandler {
    private static final Logger LOG = Logger.getLogger(JMDriverAgent.class.getName());
    private RRClient rrClient;
    private int workerID;
    private IReceiverFromDriver receiverFromDriver;
    private LinkedList<JobMasterAPI.DriverMessage> messageBuffer = new LinkedList();

    public JMDriverAgent(RRClient rrClient, int workerID) {
        this.rrClient = rrClient;
        this.workerID = workerID;
        rrClient.registerResponseHandler((Message.Builder)JobMasterAPI.DriverMessage.newBuilder(), (MessageHandler)this);
        rrClient.registerResponseHandler((Message.Builder)JobMasterAPI.WorkerMessage.newBuilder(), (MessageHandler)this);
        rrClient.registerResponseHandler((Message.Builder)JobMasterAPI.WorkerMessageResponse.newBuilder(), (MessageHandler)this);
    }

    public boolean addReceiverFromDriver(IReceiverFromDriver receiverFromDriver1) {
        if (this.receiverFromDriver != null) {
            return false;
        }
        this.receiverFromDriver = receiverFromDriver1;
        this.deliverBufferedMessages();
        return true;
    }

    public boolean sendToDriver(Message message) {
        JobMasterAPI.WorkerMessage workerMessage = JobMasterAPI.WorkerMessage.newBuilder().setData(Any.pack((Message)message).toByteString()).setWorkerID(this.workerID).build();
        RequestID requestID = this.rrClient.sendRequest((Message)workerMessage);
        if (requestID == null) {
            LOG.severe("Could not send WorkerToDriver message.");
            return false;
        }
        LOG.fine("Sent WorkerToDriver message: \n" + workerMessage);
        return true;
    }

    public void onMessage(RequestID id, int workerId, Message message) {
        if (message instanceof JobMasterAPI.WorkerMessageResponse) {
            LOG.fine("Received a WorkerMessageResponse from the master. \n" + message);
        } else if (message instanceof JobMasterAPI.DriverMessage) {
            JobMasterAPI.DriverMessage driverMessage = (JobMasterAPI.DriverMessage)message;
            if (this.receiverFromDriver == null) {
                this.messageBuffer.add(driverMessage);
            } else {
                this.deliverMessageToReceiver(driverMessage);
            }
        }
    }

    private void deliverBufferedMessages() {
        while (!this.messageBuffer.isEmpty()) {
            this.deliverMessageToReceiver(this.messageBuffer.poll());
        }
    }

    private void deliverMessageToReceiver(JobMasterAPI.DriverMessage message) {
        try {
            Any any = Any.parseFrom((ByteString)message.getData());
            this.receiverFromDriver.driverMessageReceived(any);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.log(Level.SEVERE, "Can not parse received protocol buffer message to Any", e);
        }
    }
}

