/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.server;

import edu.iu.dsc.tws.api.faulttolerance.JobFaultListener;
import edu.iu.dsc.tws.api.resource.IWorkerFailureListener;
import edu.iu.dsc.tws.api.resource.InitBarrierListener;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class JobFailureWatcher
implements IWorkerFailureListener,
InitBarrierListener {
    private static final Logger LOG = Logger.getLogger(JobFailureWatcher.class.getName());
    private List<JobFaultListener> jobFaultListeners = new LinkedList<JobFaultListener>();
    private boolean jobFaulty = false;
    private boolean firstInitBarrierProceeded = false;

    public boolean isJobFaulty() {
        return this.jobFaulty;
    }

    public void addJobFaultListener(JobFaultListener jobFaultListener) {
        this.jobFaultListeners.add(jobFaultListener);
    }

    public void allArrived() {
        this.firstInitBarrierProceeded = true;
        this.jobFaulty = false;
        this.jobFaultListeners.forEach(listener -> listener.faultRestored());
    }

    public void failed(int workerID) {
        if (!this.firstInitBarrierProceeded) {
            return;
        }
        this.jobBecomesFaulty();
    }

    public void restarted(JobMasterAPI.WorkerInfo workerInfo) {
        if (!this.firstInitBarrierProceeded) {
            return;
        }
        this.jobBecomesFaulty();
    }

    private void jobBecomesFaulty() {
        if (!this.jobFaulty) {
            this.jobFaulty = true;
            LOG.fine("Calling faultOccurred()");
            this.jobFaultListeners.forEach(listener -> listener.faultOccurred());
        }
    }
}

