/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.dashclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.iu.dsc.tws.master.dashclient.messages.JobStateChange;
import edu.iu.dsc.tws.master.dashclient.messages.RegisterJob;
import edu.iu.dsc.tws.master.dashclient.messages.RegisterWorker;
import edu.iu.dsc.tws.master.dashclient.messages.ScaledWorkers;
import edu.iu.dsc.tws.master.dashclient.messages.WorkerStateChange;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class DashboardClient {
    private static final Logger LOG = Logger.getLogger(DashboardClient.class.getName());
    private String dashHost;
    private String jobID;
    private PoolingHttpClientConnectionManager poolingConnManager;
    private CloseableHttpClient httpClient;
    private int numberOfConnections = 3;
    private ObjectMapper mapper;

    public DashboardClient(String dashHost, String jobID, int numberOfConnections) {
        this.dashHost = dashHost;
        this.jobID = jobID;
        this.numberOfConnections = numberOfConnections;
        this.poolingConnManager = new PoolingHttpClientConnectionManager();
        this.poolingConnManager.setMaxTotal(numberOfConnections);
        this.poolingConnManager.setDefaultMaxPerRoute(numberOfConnections);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.poolingConnManager).build();
        this.mapper = new ObjectMapper();
    }

    private HttpPost constructHttpPost(String endPoint, String jsonStr) {
        HttpPost httpPost = new HttpPost(endPoint);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        StringEntity entity = null;
        try {
            entity = new StringEntity(jsonStr);
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "Could not create StringEntity from json string.", e);
            return null;
        }
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }

    public boolean registerJob(JobAPI.Job job, JobMasterAPI.NodeInfo jobMasterNodeInfo) {
        String jsonStr;
        RegisterJob registerJob = new RegisterJob(this.jobID, job, jobMasterNodeInfo);
        LOG.fine("Registering job to dashboard: " + job + "jobMasterNodeInfo: " + jobMasterNodeInfo);
        String endPoint = this.dashHost + "/jobs/";
        try {
            jsonStr = this.mapper.writeValueAsString((Object)registerJob);
        }
        catch (JsonProcessingException e) {
            LOG.log(Level.SEVERE, "Could not convert java entity object to Json string.", e);
            return false;
        }
        HttpPost httpPost = this.constructHttpPost(endPoint, jsonStr);
        if (httpPost == null) {
            return false;
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                LOG.info("Registered JobMaster with Dashboard. jobID: " + this.jobID);
                return true;
            }
            LOG.severe("Could not register JobMaster with Dashboard for jobID: " + this.jobID + ". Response: " + response.toString());
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not execute Http Request.", e);
            return false;
        }
    }

    public boolean jobStateChange(JobAPI.JobState state) {
        String jsonStr;
        JobStateChange jobStateChange = new JobStateChange(state.name());
        String endPoint = this.dashHost + "/jobs/" + this.jobID + "/state/";
        try {
            jsonStr = this.mapper.writeValueAsString((Object)jobStateChange);
        }
        catch (JsonProcessingException e) {
            LOG.log(Level.SEVERE, "Could not convert java entity object to Json string.", e);
            return false;
        }
        HttpPost httpPost = this.constructHttpPost(endPoint, jsonStr);
        if (httpPost == null) {
            return false;
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                LOG.info("Job " + state.name() + " message sent to Dashboard successfully.");
                return true;
            }
            LOG.severe("Job " + state.name() + " message could not be sent to Dashboard. Response: " + response.toString());
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not execute Http Request.", e);
            return false;
        }
    }

    public boolean scaledWorkers(int change, int numberOfWorkers, List<Integer> killedWorkers) {
        String jsonStr;
        ScaledWorkers scaledWorkers = new ScaledWorkers(change, numberOfWorkers, killedWorkers);
        String endPoint = this.dashHost + "/jobs/" + this.jobID + "/scale/";
        try {
            jsonStr = this.mapper.writeValueAsString((Object)scaledWorkers);
        }
        catch (JsonProcessingException e) {
            LOG.log(Level.SEVERE, "Could not convert java entity object to Json string.", e);
            return false;
        }
        HttpPost httpPost = this.constructHttpPost(endPoint, jsonStr);
        if (httpPost == null) {
            return false;
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                LOG.info("ScaledWorkers message sent to Dashboard successfully. change: " + change + " numberOfWorkers: " + numberOfWorkers);
                return true;
            }
            LOG.severe("ScaledWorkers message could not be sent to Dashboard. Response: " + response.toString());
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not execute Http Request.", e);
            return false;
        }
    }

    public boolean registerWorker(JobMasterAPI.WorkerInfo workerInfo, JobMasterAPI.WorkerState initialState) {
        String jsonStr;
        RegisterWorker registerWorker = new RegisterWorker(this.jobID, workerInfo, initialState);
        String endPoint = this.dashHost + "/workers/";
        try {
            jsonStr = this.mapper.writeValueAsString((Object)registerWorker);
        }
        catch (JsonProcessingException e) {
            LOG.log(Level.SEVERE, "Could not convert java entity object to Json string.", e);
            return false;
        }
        HttpPost httpPost = this.constructHttpPost(endPoint, jsonStr);
        if (httpPost == null) {
            return false;
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                LOG.info("Registered Worker with Dashboard successfully for workerID: " + workerInfo.getWorkerID());
                return true;
            }
            LOG.severe("Sending RegisterWorker message to Dashboard is unsuccessful for workerID: " + workerInfo.getWorkerID() + ". Response: " + response.toString());
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not execute Http Request.", e);
            return false;
        }
    }

    public boolean workerStateChange(int workerID, JobMasterAPI.WorkerState state) {
        String jsonStr;
        WorkerStateChange workerStateChange = new WorkerStateChange(state.name());
        String endPoint = this.dashHost + "/workers/" + this.jobID + "/" + workerID + "/state/";
        try {
            jsonStr = this.mapper.writeValueAsString((Object)workerStateChange);
        }
        catch (JsonProcessingException e) {
            LOG.log(Level.SEVERE, "Could not convert java entity object to Json string.", e);
            return false;
        }
        HttpPost httpPost = this.constructHttpPost(endPoint, jsonStr);
        if (httpPost == null) {
            return false;
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                LOG.info("Sent Worker " + state.name() + " message to Dashboard successfully for workerID: " + workerID);
                return true;
            }
            LOG.severe("Sending Worker " + state.name() + " message to Dashboard is unsuccessful for workerID: " + workerID + " Response: " + response.toString());
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not execute Http Request.", e);
            return false;
        }
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        this.poolingConnManager.close();
    }
}

