/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.driver;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.common.zk.ZKBarrierManager;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.common.zk.ZKPersStateManager;
import edu.iu.dsc.tws.common.zk.ZKUtils;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;

public class ZKJobUpdater {
    private static final Logger LOG = Logger.getLogger(ZKJobUpdater.class.getName());
    private Config config;

    public ZKJobUpdater(Config config) {
        this.config = config;
    }

    public void updateJob(JobAPI.Job job) throws Twister2Exception {
        if (!ZKContext.isZooKeeperServerUsed((Config)this.config)) {
            return;
        }
        CuratorFramework client = ZKUtils.connectToServer((String)ZKContext.serverAddresses((Config)this.config));
        String rootPath = ZKContext.rootNode((Config)this.config);
        try {
            ZKPersStateManager.updateJobZNode((CuratorFramework)client, (String)rootPath, (JobAPI.Job)job);
        }
        catch (Exception e) {
            throw new Twister2Exception("Could not update job znode", (Throwable)e);
        }
    }

    public boolean removeInitialStateZNodes(String jobID, int minWorkerID, int maxWorkerID) {
        if (!ZKContext.isZooKeeperServerUsed((Config)this.config)) {
            return true;
        }
        CuratorFramework client = ZKUtils.connectToServer((String)ZKContext.serverAddresses((Config)this.config));
        String rootPath = ZKContext.rootNode((Config)this.config);
        try {
            ZKPersStateManager.removeScaledDownZNodes((CuratorFramework)client, (String)rootPath, (String)jobID, (int)minWorkerID, (int)maxWorkerID);
            ZKBarrierManager.removeScaledDownZNodes((CuratorFramework)client, (String)rootPath, (String)jobID, (int)minWorkerID, (int)maxWorkerID);
            return true;
        }
        catch (Twister2Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }
}

