/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.driver;

import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.common.driver.IScaler;
import edu.iu.dsc.tws.common.driver.IScalerPerCluster;
import edu.iu.dsc.tws.common.driver.NullScalar;
import edu.iu.dsc.tws.master.driver.ZKJobUpdater;
import edu.iu.dsc.tws.master.server.WorkerMonitor;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Scaler
implements IScaler {
    private static final Logger LOG = Logger.getLogger(Scaler.class.getName());
    private IScalerPerCluster clusterScaler;
    private WorkerMonitor workerMonitor;
    private ZKJobUpdater zkJobUpdater;
    private JobAPI.Job job;

    public Scaler(JobAPI.Job job, IScalerPerCluster clusterScaler, WorkerMonitor workerMonitor, ZKJobUpdater zkJobUpdater) {
        this.job = job;
        this.workerMonitor = workerMonitor;
        this.clusterScaler = clusterScaler;
        this.zkJobUpdater = zkJobUpdater;
        if (this.clusterScaler == null) {
            this.clusterScaler = new NullScalar();
        }
    }

    public boolean isScalable() {
        return this.clusterScaler.isScalable();
    }

    public boolean scaleUpWorkers(int instancesToAdd) {
        LOG.info("Current numberOfWorkers: " + this.job.getNumberOfWorkers() + ", new workers to be added: " + instancesToAdd);
        if (!this.isScalable()) {
            LOG.severe("Job is not scalable. Either ComputeResource is not scalable or this is an OpenMPI job.");
            return false;
        }
        if (instancesToAdd <= 0) {
            LOG.severe("instancesToAdd has to be a positive integer");
            return false;
        }
        boolean scaledUp = this.clusterScaler.scaleUpWorkers(instancesToAdd);
        if (!scaledUp) {
            return false;
        }
        this.workerMonitor.workersScaledUp(instancesToAdd);
        int numberOfWorkers = this.job.getNumberOfWorkers() + instancesToAdd;
        return this.updateJobInZK(numberOfWorkers);
    }

    public boolean scaleDownWorkers(int instancesToRemove) {
        if (!this.isScalable()) {
            LOG.severe("Job is not scalable. Either ComputeResource is not scalable or this is an OpenMPI job.");
            return false;
        }
        if (instancesToRemove <= 0) {
            LOG.severe("instancesToRemove has to be a positive integer");
            return false;
        }
        boolean scaledDown = this.clusterScaler.scaleDownWorkers(instancesToRemove);
        if (!scaledDown) {
            return false;
        }
        this.workerMonitor.workersScaledDown(instancesToRemove);
        int minID = this.job.getNumberOfWorkers() - instancesToRemove;
        int maxID = this.job.getNumberOfWorkers();
        int numberOfWorkers = this.job.getNumberOfWorkers() - instancesToRemove;
        boolean updatedJobInZK = this.updateJobInZK(numberOfWorkers);
        boolean checkZNodesDeleted = this.zkJobUpdater.removeInitialStateZNodes(this.job.getJobName(), minID, maxID);
        return updatedJobInZK && checkZNodesDeleted;
    }

    private boolean updateJobInZK(int numberOfWorkers) {
        this.job = this.job.toBuilder().setNumberOfWorkers(numberOfWorkers).build();
        try {
            this.zkJobUpdater.updateJob(this.job);
            return true;
        }
        catch (Twister2Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }
}

