/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master.dashclient.messages;

import edu.iu.dsc.tws.master.dashclient.models.ComputeResource;
import edu.iu.dsc.tws.master.dashclient.models.JobState;
import edu.iu.dsc.tws.master.dashclient.models.Node;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;

public class RegisterJob {
    private String jobID;
    private String jobName;
    private int numberOfWorkers;
    private String state;
    private String workerClass;
    private Node node;
    private ComputeResource[] computeResources;

    public RegisterJob() {
    }

    public RegisterJob(String jobID, JobAPI.Job job, JobMasterAPI.NodeInfo nodeInfo) {
        this.jobID = jobID;
        this.jobName = job.getJobName();
        this.numberOfWorkers = job.getNumberOfWorkers();
        this.state = JobState.STARTING.name();
        this.workerClass = job.getWorkerClassName();
        this.node = new Node(nodeInfo);
        this.computeResources = new ComputeResource[job.getComputeResourceList().size()];
        int i = 0;
        for (JobAPI.ComputeResource cr : job.getComputeResourceList()) {
            this.computeResources[i++] = new ComputeResource(cr);
        }
    }

    public String getJobID() {
        return this.jobID;
    }

    public String getJobName() {
        return this.jobName;
    }

    public int getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    public String getState() {
        return this.state;
    }

    public String getWorkerClass() {
        return this.workerClass;
    }

    public Node getNode() {
        return this.node;
    }

    public ComputeResource[] getComputeResources() {
        return this.computeResources;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setNumberOfWorkers(int numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setWorkerClass(String workerClass) {
        this.workerClass = workerClass;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setComputeResources(ComputeResource[] computeResources) {
        this.computeResources = computeResources;
    }
}

