/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;

public class JobMasterContext
extends Context {
    public static final String JOB_MASTER_USED = "twister2.job.master.used";
    public static final boolean JOB_MASTER_RUNS_IN_CLIENT_DEFAULT = false;
    public static final String JOB_MASTER_RUNS_IN_CLIENT = "twister2.job.master.runs.in.client";
    public static final int JOB_MASTER_PORT_DEFAULT = 11011;
    public static final String JOB_MASTER_PORT = "twister2.job.master.port";
    public static final String JOB_MASTER_IP = "twister2.job.master.ip";
    public static final String DASHBOARD_HOST = "twister2.dashboard.host";
    public static final long WORKER_TO_JOB_MASTER_RESPONSE_WAIT_DURATION_DEFAULT = 1000L;
    public static final String WORKER_TO_JOB_MASTER_RESPONSE_WAIT_DURATION = "twister2.worker.to.job.master.response.wait.duration";
    public static final double JOB_MASTER_CPU_DEFAULT = 0.2;
    public static final String JOB_MASTER_CPU = "twister2.job.master.cpu";
    public static final int JOB_MASTER_RAM_DEFAULT = 1024;
    public static final String JOB_MASTER_RAM = "twister2.job.master.ram";
    public static final double VOLATILE_VOLUME_DEFAULT = 1.0;
    public static final String VOLATILE_VOLUME = "twister2.job.master.volatile.volume.size";
    public static final double PERSISTENT_VOLUME_DEFAULT = 1.0;
    public static final String PERSISTENT_VOLUME = "twister2.job.master.persistent.volume.size";
    public static final int JM_TO_DASHBOARD_CONNECTIONS_DEFAULT = 3;
    public static final String JM_TO_DASHBOARD_CONNECTIONS = "twister2.job.master.to.dashboard.connections";

    public static boolean jobMasterRunsInClient(Config cfg) {
        return cfg.getBooleanValue(JOB_MASTER_RUNS_IN_CLIENT, false);
    }

    public static int jobMasterPort(Config cfg) {
        return cfg.getIntegerValue(JOB_MASTER_PORT, 11011);
    }

    public static String jobMasterIP(Config cfg) {
        return cfg.getStringValue(JOB_MASTER_IP);
    }

    public static long responseWaitDuration(Config cfg) {
        return cfg.getLongValue(WORKER_TO_JOB_MASTER_RESPONSE_WAIT_DURATION, 1000L);
    }

    public static double volatileVolumeSize(Config cfg) {
        return cfg.getDoubleValue(VOLATILE_VOLUME, 1.0);
    }

    public static boolean volatileVolumeRequested(Config cfg) {
        return JobMasterContext.volatileVolumeSize(cfg) > 0.0;
    }

    public static double persistentVolumeSize(Config cfg) {
        return cfg.getDoubleValue(PERSISTENT_VOLUME, 1.0);
    }

    public static boolean persistentVolumeRequested(Config cfg) {
        return JobMasterContext.persistentVolumeSize(cfg) > 0.0;
    }

    public static double jobMasterCpu(Config cfg) {
        return cfg.getDoubleValue(JOB_MASTER_CPU, 0.2);
    }

    public static int jobMasterRAM(Config cfg) {
        return cfg.getIntegerValue(JOB_MASTER_RAM, 1024);
    }

    public static String dashboardHost(Config cfg) {
        return cfg.getStringValue(DASHBOARD_HOST);
    }

    public static int jmToDashboardConnections(Config cfg) {
        return cfg.getIntegerValue(JM_TO_DASHBOARD_CONNECTIONS, 3);
    }

    public static boolean isJobMasterUsed(Config cfg) {
        return cfg.getBooleanValue(JOB_MASTER_USED, true);
    }

    public static Config updateDashboardHost(Config cfg, String dashAddress) {
        return Config.newBuilder().putAll(cfg).put(DASHBOARD_HOST, (Object)dashAddress).build();
    }
}

