/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.local.mock;

import edu.iu.dsc.tws.api.Twister2Job;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.JobFaultyException;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;

public class MockWorkerController
implements IWorkerController {
    private Twister2Job twister2Job;
    private Config config;
    private final int workerId;
    private CyclicBarrier cyclicBarrier;

    public MockWorkerController(Twister2Job twister2Job, Config config, int workerId, CyclicBarrier cyclicBarrier) {
        this.twister2Job = twister2Job;
        this.config = config;
        this.workerId = workerId;
        this.cyclicBarrier = cyclicBarrier;
    }

    public JobMasterAPI.WorkerInfo getWorkerInfo() {
        return this.getWorkerInfoForID(this.workerId);
    }

    public JobMasterAPI.WorkerInfo getWorkerInfoForID(int id) {
        return JobMasterAPI.WorkerInfo.newBuilder().setWorkerIP("localhost").setPort(8000 + id).setWorkerID(id).setNodeInfo(JobMasterAPI.NodeInfo.newBuilder().setNodeIP("localhost").setDataCenterName("dc").setRackName("rck").build()).build();
    }

    public int getNumberOfWorkers() {
        return this.twister2Job.getNumberOfWorkers();
    }

    public List<JobMasterAPI.WorkerInfo> getJoinedWorkers() {
        return this.getAllWorkers();
    }

    public List<JobMasterAPI.WorkerInfo> getAllWorkers() {
        ArrayList<JobMasterAPI.WorkerInfo> workers = new ArrayList<JobMasterAPI.WorkerInfo>();
        for (int i = 0; i < this.twister2Job.getNumberOfWorkers(); ++i) {
            workers.add(this.getWorkerInfoForID(i));
        }
        return workers;
    }

    public int workerRestartCount() {
        return 0;
    }

    public void waitOnBarrier() throws TimeoutException {
        try {
            this.cyclicBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new TimeoutException("Timeout on barrier");
        }
    }

    public void waitOnBarrier(long timeLimit) throws TimeoutException, JobFaultyException {
        this.waitOnBarrier();
    }

    public void waitOnInitBarrier() throws TimeoutException {
        this.waitOnBarrier();
    }
}

