/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.local.util;

import edu.iu.dsc.tws.api.Twister2Job;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.tset.TBaseGraph;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.SecureClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalClassLoader
extends SecureClassLoader {
    private static final Logger LOG = Logger.getLogger(LocalClassLoader.class.getName());
    public Set<String> twsClassesToExclude = new HashSet<String>();
    public Set<String> twsPackagesToExclude = new HashSet<String>();
    public Set<String> classesToLoad = new HashSet<String>();

    public LocalClassLoader(ClassLoader parent) {
        super(parent);
        this.twsClassesToExclude.add(Twister2Job.class.getName());
        this.twsClassesToExclude.add(Config.class.getName());
        this.twsClassesToExclude.add(Config.Builder.class.getName());
        this.twsClassesToExclude.add(TBaseGraph.class.getName());
        this.twsPackagesToExclude.add("edu.iu.dsc.tws.proto");
        this.twsPackagesToExclude.add("edu.iu.dsc.tws");
        this.twsPackagesToExclude.add("jep");
        this.twsPackagesToExclude.add("edu.iu.dsc.tws.python.processors.JepInstance");
    }

    public void addJobClass(String jobClass) {
        this.classesToLoad.add(jobClass);
    }

    public boolean excludedPackage(String className) {
        for (String s : this.twsPackagesToExclude) {
            if (!className.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!(name.startsWith("java.") || name.startsWith("sun.") || this.twsClassesToExclude.contains(name) || this.excludedPackage(name))) {
            InputStream is = this.getResourceAsStream(name.replace(".", "/") + ".class");
            try {
                int readBytes;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((readBytes = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, readBytes);
                }
                byte[] bytes = baos.toByteArray();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error loading " + name, e);
                throw new Twister2RuntimeException((Throwable)e);
            }
        }
        return super.loadClass(name);
    }
}

