/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.local;

import edu.iu.dsc.tws.api.Twister2Job;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.driver.DriverJobState;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.scheduler.Twister2JobState;
import edu.iu.dsc.tws.local.mock.MockWorker;
import edu.iu.dsc.tws.local.util.LocalClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CyclicBarrier;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class LocalSubmitter {
    private static final Logger LOG = Logger.getLogger(LocalSubmitter.class.getName());
    private static boolean prepared = false;
    private static boolean failed = false;
    private static Throwable fault;
    private static final String[] FILES_LIST;

    private LocalSubmitter() {
    }

    private static LocalSubmitter prepare(String configDir) {
        System.setProperty("cluster_type", "standalone");
        File cDir = new File(configDir, "standalone");
        for (String file : FILES_LIST) {
            File toCheck = new File(cDir, file);
            if (toCheck.exists()) continue;
            throw new Twister2RuntimeException("Couldn't find " + file + " in config directory specified.");
        }
        System.setProperty("config_dir", configDir);
        System.setProperty("twister2_home", System.getProperty("java.io.tmpdir"));
        try {
            File commonConfig = new File(configDir, "common");
            FileInputStream fis = new FileInputStream(new File(commonConfig, "logger.properties"));
            LogManager.getLogManager().readConfiguration(fis);
        }
        catch (IOException e) {
            LOG.warning("Couldn't load logging configuration");
        }
        prepared = true;
        return new LocalSubmitter();
    }

    private static LocalSubmitter prepare() {
        try {
            File tempDir = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]).toFile();
            File commonConfig = new File(tempDir, "common");
            File standaloneConfig = new File(tempDir, "standalone");
            ArrayList<File> directories = new ArrayList<File>();
            directories.add(commonConfig);
            directories.add(standaloneConfig);
            ArrayList<File> files = new ArrayList<File>();
            for (String f : FILES_LIST) {
                files.add(new File(commonConfig, f));
                files.add(new File(standaloneConfig, f));
            }
            files.add(new File(commonConfig, "logger.properties"));
            directories.forEach(File::mkdir);
            for (File file : files) {
                file.createNewFile();
            }
            return LocalSubmitter.prepare(tempDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new Twister2RuntimeException("Failed to create a mock config directory");
        }
    }

    public static Twister2JobState submitJob(Twister2Job twister2Job) {
        return LocalSubmitter.submitJob(twister2Job, Config.newBuilder().build());
    }

    public static Twister2JobState submitJob(Twister2Job twister2Job, String configDir, Config config) {
        LocalSubmitter.prepare(configDir);
        return LocalSubmitter.submitJob(twister2Job, config);
    }

    public static Twister2JobState submitJob(Twister2Job twister2Job, String configDir) {
        LocalSubmitter.prepare(configDir);
        return LocalSubmitter.submitJob(twister2Job);
    }

    public static Twister2JobState submitJob(Twister2Job twister2Job, Config config) {
        Twister2JobState state = new Twister2JobState(false);
        if (!prepared) {
            LocalSubmitter.prepare();
        }
        Config newConfig = LocalSubmitter.overrideConfigs(config);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(twister2Job.getNumberOfWorkers());
        for (int i = 0; i < twister2Job.getNumberOfWorkers(); ++i) {
            LocalSubmitter.startWorker(twister2Job, newConfig, i, cyclicBarrier);
        }
        if (failed) {
            state.setJobstate(DriverJobState.FAILED);
            state.setCause((Exception)fault);
        } else {
            state.setJobstate(DriverJobState.COMPLETED);
        }
        failed = false;
        fault = null;
        return state;
    }

    private static Config overrideConfigs(Config config) {
        return Config.newBuilder().putAll(config).put("twister2.network.channel.class", (Object)"edu.iu.dsc.tws.comms.tcp.TWSTCPChannel").put("twister2.job.master.used", (Object)false).put("twister2.checkpointing.enable", (Object)false).build();
    }

    private static void startWorker(Twister2Job twister2Job, Config config, int workerId, CyclicBarrier cyclicBarrier) {
        Thread.UncaughtExceptionHandler hndler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                failed = true;
                fault = ex;
            }
        };
        LocalClassLoader localClassLoader = new LocalClassLoader(LocalSubmitter.class.getClassLoader());
        localClassLoader.addJobClass(twister2Job.getWorkerClass());
        try {
            Object o = localClassLoader.loadClass(MockWorker.class.getName()).getConstructor(twister2Job.getClass(), config.getClass(), Integer.class, CyclicBarrier.class).newInstance(twister2Job, config, workerId, cyclicBarrier);
            Thread thread = new Thread((Runnable)o);
            thread.setName("worker-" + workerId);
            thread.setUncaughtExceptionHandler(hndler);
            thread.start();
            thread.join();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        FILES_LIST = new String[]{"core.yaml", "network.yaml", "data.yaml", "resource.yaml", "task.yaml"};
    }
}

