/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.connectors;

import edu.iu.dsc.tws.connectors.KafkaTopicDescription;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionFinder {
    private static Logger log = LoggerFactory.getLogger(KafkaPartitionFinder.class);
    private String[] bootstrapServers;
    private int numRetries;
    private int worldSize;
    private int myIndex;
    private Consumer<?, ?> consumer;
    private Properties kafkaConsumerConfig;
    private KafkaTopicDescription topics;

    public KafkaPartitionFinder(Properties kafkaConsumerConfig, int worldSize, int myIndex, KafkaTopicDescription topics) {
        this.bootstrapServers = kafkaConsumerConfig.getProperty("bootstrap.servers").split(",");
        this.numRetries = 10;
        this.myIndex = myIndex;
        this.worldSize = worldSize;
        this.kafkaConsumerConfig = kafkaConsumerConfig;
        this.topics = topics;
        this.initializeConnection();
    }

    private List<TopicPartition> getAllPartitions() {
        if (this.topics.isFixedTopics()) {
            return this.getAllPartitionsForTopics(this.topics.getFixedTopics());
        }
        List<String> allTopics = this.allTopics();
        LinkedList<String> relevantTopics = new LinkedList<String>();
        Pattern pattern = this.topics.getTopicPattern();
        for (String topic : allTopics) {
            Matcher matcher = pattern.matcher(topic);
            if (!matcher.find()) continue;
            relevantTopics.add(topic);
        }
        return this.getAllPartitionsForTopics(relevantTopics);
    }

    public List<TopicPartition> getRelevantPartitions() {
        LinkedList<TopicPartition> relevantPartitions = new LinkedList<TopicPartition>();
        List<TopicPartition> allPartitions = this.getAllPartitions();
        for (TopicPartition partition : allPartitions) {
            if (!this.assignPartition(partition)) continue;
            relevantPartitions.add(partition);
        }
        log.info("{} Partitions found for Process-{}", (Object)relevantPartitions.size(), (Object)this.myIndex);
        return relevantPartitions;
    }

    private KafkaPartitionFinder initializeConnection() {
        this.consumer = new KafkaConsumer(this.kafkaConsumerConfig);
        return this;
    }

    private List<String> allTopics() throws WakeupException {
        try {
            return new LinkedList<String>(this.consumer.listTopics().keySet());
        }
        catch (WakeupException e) {
            throw new WakeupException();
        }
    }

    private List<TopicPartition> getAllPartitionsForTopics(List<String> topics2) throws WakeupException {
        LinkedList<TopicPartition> partitions = new LinkedList<TopicPartition>();
        try {
            for (String topic : topics2) {
                for (PartitionInfo partitionInfo : this.consumer.partitionsFor(topic)) {
                    partitions.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
                }
            }
        }
        catch (WakeupException e) {
            throw new WakeupException();
        }
        return partitions;
    }

    protected void wakeupConnections() {
        if (this.consumer != null) {
            this.consumer.wakeup();
        }
    }

    protected void closeConnections() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
    }

    private boolean assignPartition(TopicPartition topicPartition) {
        int startIndxOfTopic = topicPartition.topic().hashCode();
        int partitionAssignIndex = (startIndxOfTopic + topicPartition.partition()) % this.worldSize;
        return partitionAssignIndex == this.myIndex;
    }

    public KafkaPartitionFinder() {
    }
}

