/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.connectors.config;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public abstract class KafkaProducerConfig {
    public static Properties getConfig(List<String> servers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", KafkaProducerConfig.getStrServers(servers));
        props.put("acks", "all");
        props.put("retries", (Object)3);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x333328);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return props;
    }

    private static String getStrServers(List<String> servers) {
        StringBuilder strServers = new StringBuilder();
        for (int i = 0; i < servers.size(); ++i) {
            strServers.append(servers.get(i));
            if (i + 1 >= servers.size()) continue;
            strServers.append(",");
        }
        return strServers.toString();
    }

    public static Properties setProps(Properties conf, Properties newProps) {
        Enumeration<?> keys = newProps.propertyNames();
        while (keys.hasMoreElements()) {
            if (!(keys.nextElement() instanceof String)) continue;
            String key = (String)keys.nextElement();
            String value = newProps.getProperty(key);
            conf.put(key, value);
        }
        return conf;
    }
}

