/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.connectors.config;

import java.util.List;
import java.util.Properties;

public abstract class KafkaConsumerConfig {
    public static Properties getStringDeserializerConfig(List<String> servers, String consumerGroup) {
        String tempGroup = consumerGroup;
        if (tempGroup == null) {
            tempGroup = "TwsKafkaConsumer";
        }
        Properties props = new Properties();
        props.put("bootstrap.servers", KafkaConsumerConfig.getStrServers(servers));
        props.put("group.id", tempGroup);
        props.put("enable.auto.commit", "false");
        props.put("session.timeout.ms", "30000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        return props;
    }

    public static Properties getLongDeserializerConfig(List<String> servers, String consumerGroup) {
        String tempGroup = consumerGroup;
        if (tempGroup == null) {
            tempGroup = "TwsKafkaConsumer";
        }
        Properties props = new Properties();
        props.put("bootstrap.servers", KafkaConsumerConfig.getStrServers(servers));
        props.put("group.id", tempGroup);
        props.put("enable.auto.commit", "false");
        props.put("session.timeout.ms", "30000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.LongDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.LongDeserializer");
        return props;
    }

    private static String getStrServers(List<String> servers) {
        StringBuilder strServers = new StringBuilder();
        for (int i = 0; i < servers.size(); ++i) {
            strServers.append(servers.get(i));
            if (i + 1 >= servers.size()) continue;
            strServers.append(",");
        }
        return strServers.toString();
    }

    public static Properties getSimpleKafkaConsumer(List<String> servers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", KafkaConsumerConfig.getStrServers(servers));
        props.put("group.id", "partitionFinding");
        props.put("enable.auto.commit", "false");
        props.put("session.timeout.ms", "30000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.LongDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.LongDeserializer");
        return props;
    }
}

