/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.connectors;

import edu.iu.dsc.tws.api.compute.TaskContext;
import edu.iu.dsc.tws.api.compute.nodes.BaseSource;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.connectors.KafkaConsumerThread;
import edu.iu.dsc.tws.connectors.KafkaPartitionFinder;
import edu.iu.dsc.tws.connectors.KafkaTopicDescription;
import edu.iu.dsc.tws.connectors.KafkaTopicPartitionState;
import edu.iu.dsc.tws.connectors.config.KafkaConsumerConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwsKafkaConsumer<T>
extends BaseSource {
    private static final long serialVersionUID = -264264120110286748L;
    private static Logger log = LoggerFactory.getLogger(TwsKafkaConsumer.class);
    private Properties kafkaConfigs;
    private Properties simpleKafkaConfig;
    private List<TopicPartition> topicPartitions;
    private int myIndex;
    private int worldSize;
    private TaskContext taskContext;
    private Map<TopicPartition, OffsetAndMetadata> offsetsToCommit;
    private List<KafkaTopicPartitionState> topicPartitionStates;
    private String edge;
    private boolean restoreState = false;
    private volatile boolean consumerThreadStarted = false;
    private KafkaPartitionFinder partitionFinder;
    private KafkaTopicDescription topicDescription;
    private KafkaConsumerThread<T> kafkaConsumerThread;

    public void execute() {
        try {
            this.kafkaConsumerThread.run();
        }
        catch (IllegalThreadStateException e) {
            log.info(e.toString());
        }
    }

    public void prepare(Config cfg, TaskContext context) {
        this.myIndex = cfg.getIntegerValue("twister2.container.id", 0);
        this.worldSize = context.getParallelism();
        log.info("myID : {} , worldSize : {} ", (Object)this.myIndex, (Object)this.worldSize);
        this.partitionFinder = new KafkaPartitionFinder(this.simpleKafkaConfig, this.worldSize, this.myIndex, this.topicDescription);
        this.topicPartitions = this.partitionFinder.getRelevantPartitions();
        this.topicPartitionStates = new LinkedList<KafkaTopicPartitionState>();
        for (TopicPartition tp : this.topicPartitions) {
            this.topicPartitionStates.add(new KafkaTopicPartitionState(tp));
        }
        this.kafkaConsumerThread = new KafkaConsumerThread(this.kafkaConfigs, this.offsetsToCommit, this.topicPartitions, this.topicPartitionStates, context, this.edge);
        this.kafkaConsumerThread.assignPartitions();
        log.info("{} partitions are assigned", (Object)this.topicPartitions.size());
        this.kafkaConsumerThread.setSeekToBeginning();
    }

    public TwsKafkaConsumer(List<String> topics, List<String> servers, String consumerGroup, String edge) {
        this.topicDescription = new KafkaTopicDescription(topics);
        this.kafkaConfigs = this.createKafkaConfig(servers, consumerGroup);
        this.simpleKafkaConfig = this.createSimpleKafkaConfig(servers);
        this.edge = edge;
    }

    public TwsKafkaConsumer(Pattern topicPattern, List<String> servers, String consumerGroup, String edge) {
        this.topicDescription = new KafkaTopicDescription(topicPattern);
        this.kafkaConfigs = this.createKafkaConfig(servers, consumerGroup);
        this.simpleKafkaConfig = this.createSimpleKafkaConfig(servers);
        this.edge = edge;
    }

    public Properties getKafkaConfigs() {
        return this.kafkaConfigs;
    }

    public void setKafkaConfigs(Properties kafkaConfigs) {
        this.kafkaConfigs = kafkaConfigs;
    }

    private Properties createKafkaConfig(List<String> servers, String consumerGroup) {
        return KafkaConsumerConfig.getStringDeserializerConfig(servers, consumerGroup);
    }

    private Properties createSimpleKafkaConfig(List<String> servers) {
        return KafkaConsumerConfig.getSimpleKafkaConsumer(servers);
    }

    public TwsKafkaConsumer() {
    }

    public void saveCheckpoint() {
    }
}

